package Ex6_9
model Ex6_9pfr
//PFR
annotation(experiment(StartTime=0,StopTime=50));
Real V(unit="dm^3",start=0)"volume of PBR";
Real Fa(unit="mol/s",start=4)"molar flow rate of A";
Real Fb(unit="mol/s",start=4)"molar flow rate of B";
Real Fd(unit="mol/s",start=0)"molar flow rate of desired";
Real Fu(unit="mol/s",start=0)"molar flow rate of undesired product";
Real Ft(unit="mol/s",start=8)"TOTAL molar flow rate";
parameter Real Cto(unit="mol/dm3")=0.8"total initial concentration";
parameter Real k1a(unit="dm^6/mol^2/s")=2"rate constant of 1st rxn";
parameter Real k2a(unit="dm^6/mol^2/s")=3"rate constant of 2nd rxn";
Real Cb(unit="mol/dm3",start=0)"concentration of B";
Real Ca(unit="mol/dm3",start=0.8)"concentration of A";
Real Cd(unit="mol/dm3",start=0)"concentration of D";
Real Cu(unit="mol/dm3",start=0)"concentration of U";
Real ra(unit="mol/dm3.s")"rate of rxn of A";
Real rb(unit="mol/dm3.s")"rate of rxn of B";
Real rd(unit="mol/dm3.s")"rate of rxn of D";
Real ru(unit="mol/dm3.s")"rate of rxn of U";
parameter Real Vt(unit="dm^3")=50;
parameter Real Fbo(unit="mol/s")=4"initial concentration of B";
Real Sdu(unit="1")"selectivity of mixed reactor";
equation
der(Fa)/der(V)=ra;
der(Fb)/der(V)=rb;
der(Fd)/der(V)=rd;
der(Fu)/der(V)=ru;
V=time;
Ft=Fa+Fb+Fd+Fu;
Cb=Cto*Fb/Ft;
Ca=Cto*Fa/Ft;
ra=-1*k1a*(Ca^2)*Cb-k2a*Ca*Cb^2;
rb=ra;
Cd=Cto*Fd/Ft;
Cu=Cto*Fu/Ft;
rd=k1a*(Ca^2)*Cb;
ru=k2a*Ca*Cb^2;
Sdu=Fd/Fu;

end Ex6_9pfr;

model Ex6_9mr
//Membrane reactor
//the deviation from books answer is due to rounding off error
annotation (experiment(StartTime=0,StopTime=50));
  Real V(unit = "dm^3", start = 0) "volume of PBR";
  Real Fa(unit = "mol/s", start = 4) "molar flow rate of A";
  Real Fb(unit = "mol/s", start = 0) "molar flow rate of B";
  Real Fd(unit = "mol/s", start = 0) "molar flow rate of desired";
  Real Fu(unit = "mol/s", start = 0) "molar flow rate of undesired product";
  Real Ft(unit = "mol/s", start = 4) "TOTAL molar flow rate";
  parameter Real Cto(unit = "mol/dm3") = 0.8 "total initial concentration";
  parameter Real k1a(unit = "dm^6/mol^2/s") = 2 "rate constant of 1st rxn";
  parameter Real k2a(unit = "dm^6/mol^2/s") = 3 "rate constant of 2nd rxn";
  Real Cb(unit = "mol/dm3", start = 0) "concentration of B";
  Real Ca(unit = "mol/dm3", start = 0.8) "concentration of A";
  Real Cd(unit = "mol/dm3", start = 0) "concentration of D";
  Real Cu(unit = "mol/dm3", start = 0) "concentration of U";
  Real ra(unit = "mol/dm3.s") "rate of rxn of A";
  Real rb(unit = "mol/dm3.s") "rate of rxn of B";
  Real rd(unit = "mol/dm3.s") "rate of rxn of D";
  Real ru(unit = "mol/dm3.s") "rate of rxn of U";
  parameter Real Vt(unit = "dm^3") = 50;
  parameter Real Fbo(unit = "mol/s") = 4 "initial concentration of B";
  Real Rb(unit = "mol/dm3.s");
  Real Sdu(unit = "1") "selectivity of mixed reactor";
equation
  der(Fa) / der(V) = ra;
  der(Fb) / der(V) = rb + Rb;
  der(Fd) / der(V) = rd;
  der(Fu) / der(V) = ru;
  V = time;
  Ft = Fa + Fb + Fd + Fu;
  Cb = Cto * Fb / Ft;
  Ca = Cto * Fa / Ft;
  ra = (-1 * k1a * Ca ^ 2 * Cb) - k2a * Ca * Cb ^ 2;
  rb = ra;
  Cd = Cto * Fd / Ft;
  Cu = Cto * Fu / Ft;
  rd = k1a * Ca ^ 2 * Cb;
  ru = k2a * Ca * Cb ^ 2;
  Rb = Fbo / Vt;
  Sdu = Fd / (Fu+0.0001);
end Ex6_9mr;

end Ex6_9;
