package Ex7_2
model Ex7_2b

annotation(experiment(StartTime=0,StopTime=12));
Real k1(unit="1/s")"rate constant for reaction 1";
parameter Real T(unit="K")=1000;
Real k2(unit="dm3/mol.s")"rate constant for reaction ";
Real k3(unit="1/s")"rate constant for reaction 3";
Real k4(unit="dm3/mol.s")"rate constant for reaction 4";
Real k5(unit="dm3/mol.s")"rate constant for reaction 5";
Real C1(unit="mol/dm3",start =0.1)"concentration of ethane";
Real C2(unit="mol/dm3")"concentration of methane radical";
Real C3(unit="mol/dm3")"concentration of methane";
Real C4(unit="mol/dm3")"concentration of ethane radical";
Real C5(unit="mol/dm3")"concentration of ethene";
Real C6(unit="mol/dm3")"concentration of hydrogen radical";
Real C7(unit="mol/dm3")"concentration of hydrogen";
Real C8(unit="mol/dm3")"concentration of butane";
Real CP1(unit="mol/dm3",start=.1)"concentration of ethane calculated by Pssh";
Real CP5(unit="mol/dm3")"concentration of ethene calculated from pssh";


equation

k1=10*exp((87500/1.987)*(1/1250-1/T));
k2=8450000*exp((13000/1.987)*(1/1250-1/T));
k3=3200000*exp((40000/1.987)*(1/1250-1/T));
k4=2.53e9*exp((9700/1.987)*(1/1250-1/T));
k5=3.98e9;
der(C1)=-k1*C1-k2*C1*C2-k4*C1*C6;
der(C2)=2*k1*C1-k2*C1*C2;
der(C6)=k3*C4-k4*C6*C1;
der(C4)=k2*C1*C2-k3*C4+k4*C6*C1-k5*C4^2;
der(C7)=k4*C1*C6;
der(C3)=k2*C1*C2;
der(C5)=k3*C4;
der(C8)=0.5*k5*C4^2;
der(CP5)=k3*((2*k1/k5)^0.5)*CP1^0.5;
der(CP1)=-k1*CP1-2*k1*CP1-(k3*(2*k1/k5)^0.5)*(CP1^0.5);
end Ex7_2b;

end Ex7_2;
