package Ex8_5
model Ex8_5a
annotation(experiment(StartTime=0,StopTime=4));
//adiabatically operated reactor//
Real X(unit="1",start=0)"conversion";
Real ra(unit="mol/dm3.s")"rate of reaction";
Real rate(unit="mol/dm3.s")"-ra";
Real V(unit="dm3")"volume of reactor";
Real T(unit="K",start =1035)"temperature";
Real deltaH(unit="J/mol")"heat of formation at temperature T";
parameter Real deltaHr(unit="J/mol")=80770"standard heat of formation";
parameter Real delCp(unit="J/mol.K")=-9"sum of heat capacity of product -heat capacity of reactants";
parameter Real Cpa(unit="J/mol.K")=163"heat capacity of A";
parameter Real To(unit="K")=1035"inlet temperature";
parameter Real Fao(unit="mol/s")=0.0376"(7850kg/h)/(58g/mol)*1000/(1000tubes)/(3600s/h)";
parameter Real Cao(unit="mol/m3")=18.8/1000"concentration of A";
parameter Real k1i(unit="1/sec")=3.58"rate constant at temperature To";
equation
der(X)=-1*ra/Fao*der(V);
der(T)=-ra*(-1*deltaH)/(Fao*(Cpa+X*delCp))*der(V);
deltaH=deltaHr+delCp*(T-298);//heat of formation at25 is 80770//
//delCp=Cpb+Cpc-Cpa difference of heat capacities
ra=-1*Cao*k1i*exp(34222*(1/To-1/T))*(1-X)*(To/T)/(1+X);
//ra=k*Cao*(1-X)*To/(1+X)/T
V=time;
rate=-ra;

end Ex8_5a;








model Ex8_5b
annotation(experiment(StartTime=0,StopTime=1));
//case 2 heat exchange with constant heating medium
Real X(unit="mol/mol",start=0)"conversion";
Real ra(unit="mol/dm3.s")"rate of reaction";
parameter Real Ua(unit="J/dm3/s/K")=16.500;
parameter Real Ta(unit="K")=1150;
Real rate(unit="mol/dm3.s")"-ra";
Real V(unit="dm3")"volume of reactor";
Real T(unit="K",start =1035)"temperature";
Real deltaH(unit="J/mol")"heat of formation at temperature T";
parameter Real deltaHr(unit="J/mol")=80770"standard heat of formation";
parameter Real delCp(unit="J/mol.K")=-9"sum of heat capacity of product -heat capacity of reactants";
parameter Real Cpa(unit="J/mol.K")=163"heat capacity of A";
parameter Real To(unit="K")=1035"inlet temperature";
parameter Real Fao(unit="mol/s")=0.0376"(7850kg/h)/(58g/mol)*1000/(1000tubes)/(3600s/h)";
parameter Real Cao(unit="mol/dm3")=.0188"concentration of A";
equation
der(X)=-1*ra/Fao*der(V);
der(T)=(Ua*(Ta-T)+ra*deltaH)/(Fao*(Cpa+X*delCp))*der(V);

deltaH=deltaHr+delCp*(T-298);//heat of formation at25 is 80770//
//delCp=Cpb+Cpc-Cpa difference of heat capacities
ra=-1*Cao*3.58*exp(34222*(1/To-1/T))*(1-X)*(To/T)/(1+X);
//ra=k*Cao*(1-X)*To/(1+X)/T
V=time;
rate=-ra*1000;
end Ex8_5b;


model Ex8_5c
annotation(experiment(StartTime=0,StopTime=1));
//heat exchange with variable heating medium temperature
Real X(unit="mol/mol",start=0)"conversion";
Real ra(unit="mol/dm3.s")"rate of reaction";
parameter Real Ua(unit="J/dm3/s/K")=16.500;
Real Ta(unit="K",start=1250);
Real rate(unit="mol/dm3.s")"-ra";
Real V(unit="dm3")"volume of reactor";
Real T(unit="K",start =1035)"temperature";
Real deltaH(unit="J/mol")"heat of formation at temperature T";
parameter Real deltaHr(unit="J/mol")=80770"standard heat of formation";
parameter Real delCp(unit="J/mol.K")=-9"sum of heat capacity of product -heat capacity of reactants";
parameter Real Cpa(unit="J/mol.K")=163"heat capacity of A";
parameter Real To(unit="K")=1035"inlet temperature";
parameter Real Fao(unit="mol/s")=0.0376"(7850kg/h)/(58g/mol)*1000/(1000tubes)/(3600s/h)";
parameter Real Cao(unit="mol/dm3")=.0188"concentration of A";
parameter Real mc(unit="mol/s")=0.11"molar flow rate of air";
parameter Real Cpc(unit="J/mol.K")=34.5"heat capacity of air";
equation
der(X)=-1*ra/Fao*der(V);
der(T)=(Ua*(Ta-T)+ra*deltaH)/(Fao*(Cpa+X*delCp))*der(V);
der(Ta)=Ua*(T-Ta)/mc/Cpc*der(V);

deltaH=deltaHr+delCp*(T-298);//heat of formation at25 is 80770//
//delCp=Cpb+Cpc-Cpa difference of heat capacities
ra=-1*Cao*3.58*exp(34222*(1/To-1/T))*(1-X)*(To/T)/(1+X);
//ra=k*Cao*(1-X)*To/(1+X)/T
V=time;
rate=-ra*1000;
end Ex8_5c;







end Ex8_5;
