model Ex8_7
annotation(experiment(StartTime=300,StopTime=600));
//small deviation from textbook answer is due to rounding off error
 Real Xeb3(unit="mol/mol")"equilibirium conversion for third reactor";
//from the Example 8_6
parameter Real X1=0.95*0.42"95%of equilibirium concentration";
Real T1(unit="K")"exit temperature before the first round of cooling";
Real Qdot(unit="cal/s")"heat load for 1st round of cooling";
parameter Real Fao(unit="mol/s")=40"feed rate";
parameter Real Cpa(unit="cal/mol.K")=50"heat capacity of A";
parameter Real T2(unit="K")=350"temp upto which cooling is available";
Real mcdot(unit="kg/s")"coolent flow rate";
parameter Real Cpc(unit="cal/mol.K")=18"heat capacity of the coolent";
parameter Real Tout(unit="K")=400"outlet temp of teh coolent";
parameter Real Tin(unit="K")=270"inlet temperature of the coolent";
parameter Real mw(unit="g/mol")=18"molecular weight of coolent";
parameter Real U(unit="cal/s.m2.K")=100"heat transfer coeff";
Real A(unit="m2")"Area of heat exchanger";
Real T(unit="K",start=298);
Real Xe(unit="mol/mol")"conversion by equilibirium constant";
Real Xeb(unit="mol/mol")"conversion by energy balance",Xeb2(unit="mol/mol");
parameter Real Cpb(unit="cal/mol.K")=50"heat capacity of B";
parameter Real delHrx(unit="cal/mol")=-20000"heat of reaction";
Real Ke(unit="1")"equilibirium constant";
Real To(unit="K")=350"temperature ";
parameter Real Th1(unit="K")=350"feed through heat exchanger";
parameter Real Th2(unit="K")=460"exiting temperature of heat exchanger";
Real Qdot2(unit="cal/s")"heat load for second heat exchanger";
Real Xe3(unit="mol/mol")"equilibirium conversion after 2rd heat exchanger";
Real X3(unit="mol/mol")"final conversion";

equation
T1=300+400*X1;
Qdot=Fao*Cpa*(T2-T1);
Qdot2=Fao*Cpa*(350-430);
mcdot=Qdot/(Cpc*(Tout-Tin))*mw/1000;
A=-1*Qdot*log((Th2-Tout)/(Th1-Tin))/U/((Th2-Tout)-(Th1-Tin));
//from ex8_6 reactor 2
Xe=Ke/(1+Ke);
Ke=100000*exp(-20000/1.987*(1/298-1/T));
T=time;

Xeb=-1*Cpa*(T-300)/delHrx;//from the Ex8.6 example
Xeb2=-1*Cpa*(T-To)/delHrx+0.4;
Xeb3=-1*Cpa*(T-To)/delHrx+0.6;
//from graph of Xe and Xeb3 one the same plot gives X=0.8 as the intersection
Xe3=0.8;//equilibirium conversion from equilibirium constant
X3=0.8*.95;

end Ex8_7;
