model Ex9_7
annotation(experiment(StartTime=0,StopTime=1.5));
parameter Real UA(unit="cal/h.K")=35000;
Real Ca(unit="mol/dm3",start=1)"concentration of A in the reactor";
parameter Real Cao(unit="mol/dm3")=4" concentration of A in the input stream";
parameter Real vo(unit="dm3/h")=240"input stream volumetric flow rate";
Real  V(unit="dm3",start=100)"volume of the reactor";
Real ra(unit="mol/dm3.h",start=0.2665)"rate of formation of A";
Real Cb(unit="mol/dm3",start=0)"concentration of Cb in the reactor";
Real rb(unit="mol/dm3.h",start=0.1332)"rate of formation of Cb";
Real Cc(unit="mol/dm3",start=0)"concentration of Cc in the reactor";
Real rc(unit="mol/dm3.h",start=0)"rate of formation of C";
Real k1a(unit="1/h");
Real k2b(unit="1/h");
Real T(unit="K",start=290)"Temperature in the reactor";
parameter Real Ta(unit="K")=298"initial temperature of the heat exchanger";
parameter Real Fao(unit="mol/h")=4*240;
parameter Real Cpa(unit="cal/mol.K")=30"heat capacity of A",To(unit="K")=305"temperature of stream",delHr1a(unit="cal/mol")=-6500,delHr2b(unit="cal/mol")=8000,Cpb(unit="cal/mol.K")=60"heat capacity of B",Cpc(unit="cal/mol.K")=20"heat capacity of C",Nh2so4(unit="mol")=100"moles of h2so4",Cph2so4(unit="cal/mol.K")=35"heat capacity";
Real r1a(unit="mol/dm3.h"),r2b(unit="mol/dm3.h");


equation
der(Ca)=ra+(Cao-Ca)*vo/V;
der(Cb)=rb-Cb*vo/V;
der(Cc)=rc-Cc*vo/V;
ra=-1*k1a*Ca;
rb=k1a*Ca/2-k2b*Cb;
rc=3*k2b*Cb;
r1a=ra;
r2b=-1*k2b*Cb;
k1a=1.25*exp(9500/1.987*(1/320-1/T));
k2b=0.08*exp(7000/1.987*(1/300-1/T));
V=100+vo*time;
//energy balance//
der(T)=(UA*(Ta-T)-Fao*Cpa*(T-To)+((delHr1a)*r1a+(delHr2b)*(r2b))*V)/((Ca*Cpa+Cb*Cpb+Cc*Cpc)*V+Nh2so4*Cph2so4);
end Ex9_7;
