model Ex2_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real a1(unit="m^2")                        "Area at point 1";
Real a2(unit="m^2")                        "Area at point 2";
Real V1(unit="m/sec")                      "Velocity at point 1";
Real V2(unit="m/sec")                      "Velocity at point 2";
Real P2(unit="Pascal")                     "Pressure at point 2";


// Parameters
 

 parameter Real D1(unit="m")=15e-02                   "Diameter at point 1" ;
 parameter Real D2(unit="m")=22.5e-02                 "Diameter at point 2" ;
 parameter Real Q(unit="m^3/sec")=0.05                "Volume flow rate" ;
 parameter Real gamma(unit="kg/m^3")=8.82e03          "Specific weight of Benzene" ;
 parameter Real z1(unit="m")=3.2                      "Elevation at point 1" ;
 parameter Real z2(unit="m")=1.2                      "Elevation at point 1" ;
 parameter Real P1(unit="Pascal")=4.4e05              "Pressure at point 1" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


a1=(pi/4)*D1^2;
a2=(pi/4)*D2^2;
V1=Q/a1;
V2=Q/a2;
//Applying bernoullis equation between 1 and 2
(P1/gamma)+(V1^2/(2*g))+z1=(P2/gamma)+(V2^2/(2*g))+z2;

//Answer may slightly vary due to rounding off error.
end Ex2_2;
