model Ex2_3

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real z3(unit="m")                               "Total head loss from 1 to 3";
Real rho_oil(unit="kg/m^3")                     "Density of oil";
Real v3(unit="m/sec")                           "Velocity at exit";
Real Q(unit="m^3/sec")                          "Flow rate";
Real P2(unit="Pascal")                          "Pressure at point 2";


// Parameters
 

 parameter Real h1(unit="m")=1.5                  "Head loss from 1 to 2" ;
 parameter Real h2(unit="m")=2.4                  "Head loss from 2 to 3" ;
 parameter Real S(unit="")=0.82                   "Specific gravity of oil" ;
 parameter Real rho_water(unit="kg/m^3")=1e03     "Density of water" ;
 parameter Real z1(unit="m")=5                    "Elevation at point 1" ;
 parameter Real z2(unit="m")=7                    "Elevation at point 2" ;
 parameter Real d(unit="m")=50e-03                "Syphon diameter" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation
z3=h1+h2;
rho_oil=S*rho_water;
v3=sqrt(2*g*(z1-z3));
Q=(pi/4)*d^2*v3;
z1=P2/rho_oil+(v3^2/(2*g))+z2;


//Answer may slightly vary due to rounding off error.
end Ex2_3;
