package Ex2_5
model Ex2_5_a

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real h_Blood(unit="m")                        "Height";
Real P2(unit="Pascal")                        "Pressure at point 2";


// Parameters
 

 parameter Real rho_Hg(unit="kg/m^3")=13600                 "Density of murcury" ;
 parameter Real rho_Blood(unit="kg/m^3")=1000               "Density of Blood" ;
 parameter Real H_hg(unit="m")=0.212                        "Height" ;
 parameter Real z1(unit="m")=0                              "Elevation at point 1" ;
 parameter Real z2(unit="m")=2.4                            "Elevation at point 2" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

h_Blood=(rho_Hg*g*H_hg)/(rho_Blood*g);
P2=(h_Blood +(z1 -z2))*(rho_Blood*g);

end Ex2_5_a;
//================================================================================================

model Ex2_5_b

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real h_Blood(unit="m")                        "Height";
Real P2(unit="Pascal")                        "Pressure at point 2";


// Parameters
 

 parameter Real rho_Hg(unit="kg/m^3")=13600                 "Density of murcury" ;
 parameter Real rho_Blood(unit="kg/m^3")=1000               "Density of Blood" ;
 parameter Real H_hg(unit="m")=0.212                        "Height" ;
 parameter Real z1(unit="m")=0                              "Elevation at point 1" ;
 parameter Real z2(unit="m")=-1.8                            "Elevation at point 2" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

h_Blood=(rho_Hg*g*H_hg)/(rho_Blood*g);
P2=(h_Blood +(z1 -z2))*(rho_Blood*g);

end Ex2_5_b;

end Ex2_5;
