model Ex2_6

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real a2(unit="m^2")                        "Area of exit pipe";
Real V2(unit="m/sec")                      "Velocity of exit pipe";
Real P1(unit="Pascal")                     "Pressure at point 1";
Real P2(unit="Pascal")                     "Pressure at point 2";
Real V1(unit="m/sec")                      "Velocity of inlet pipe";
Real y(unit="kg/m2-sec2")                  "";
Real H(unit="m")                           "Head developed by the turbine";
Real P(unit="kW")                          "Power developed by the turbine";

// Parameters
 

 parameter Real D2(unit="m")=2.7                         "Diameter at point 2" ;
 parameter Real Q(unit="m^2/sec")=30                     "Flow rate" ;
 parameter Real rho(unit="kg/m^3")=1000                  "Density of water" ;
 parameter Real Z1(unit="m")=20                          "Elevation at point 1" ;
 parameter Real Z2(unit="m")=6                           "Elevation at point 2" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

a2=(pi/4)*D2^2;
V2=Q/a2;
P1=0;
P2=0;
V1=0;
y=rho*g;
//Applying bernoullis equation in modified form at point 1 and 2

(P1/y)+((V1^2)/(2*g))+Z1=(P2/y)+((V2^2)/(2*g))+Z2+H;
P=rho*g*Q*H/1000;


//Answer may slightly vary due to rounding off error.
end Ex2_6;
