model Ex2_7

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real delta_P(unit="Pascal")                        "Difference of pressure";
Real V(unit="m/sec")                               "Velocity";

// Parameters
 

 parameter Real h(unit="m")=4e-03                         "Difference of head" ;
 parameter Real rho_air(unit="kg/m^3")=1.2                "Density of air" ;
 parameter Real rho(unit="kg/m^3")=1000                   "Density of water" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

delta_P=h*rho*g;
V=sqrt((2*delta_P)/rho_air);

end Ex2_7;
