model Ex2_8

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real A(unit="m^2")                            "Area of window";
Real V(unit="m/sec")                          "Velocity of the wind";
Real P0(unit="N/m^2")                         "Pressure on the window";
Real F(unit="N")                              "Force acting on the window";

// Parameters
 

 parameter Real L(unit="m")=1                         "Length of window" ;
 parameter Real B(unit="m")=2                         "Width of window" ;
 parameter Real rho(unit="kg/m^3")=1.2                "Density of air" ;
 parameter Real v(unit="km/hr")=100                   "Velocity of wind" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

A=L*B;
V=v*1000/3600;
P0=(rho*V^2)/2;
F=P0*A;

//Answer may slightly vary due to rounding off error.
end Ex2_8;
