model Ex5_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real Q(unit="m^3/sec")            "Flow rate";
Real V1(unit="m/sec")             "Velocity of the jet";
Real d(unit="m")                  "Diameter of the jet";
Real u(unit="m/sec")              "Velocity";
Real D(unit="m")                  "Wheel diameter";
Real w(unit="rad/sec")            "Specific speed";
Real wT(unit="")                  "Specific speed of turbine";

// Parameters
 

 parameter Real P(unit="W")=67.5e03                  "Power developed by Pelton wheel" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 parameter Real no(unit="m")=0.83                    "Overall efficiency" ;
 parameter Real H(unit="m")=60                       "Head of water" ;
 parameter Real N(unit="rev/min")=400                "Speed of Pelton wheel" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

Q=P/(no*rho*g*H);
V1=sqrt(2*g*H);
d=sqrt((Q*4)/(pi*V1));
u=0.46*V1;
D=60*u/(pi*N);
w=(2*N*pi)/60;
wT=w*((P/rho)^0.5)/((g*H)^(5/4));

end Ex5_1;
