model Ex5_3

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real u(unit="m/sec")               "Peripherial velocity";
Real hf(unit="m")                  "Head losses";
Real H(unit="m")                   "Effective head";
Real V1(unit="m/sec")              "Velocity of the jet";
Real S(unit="")                    "Speed ratio";
Real nh(unit="")                   "Hydraulic efficiency";
Real E(unit="m")                   "Euler's head";
Real n0(unit="")                   "Overall efficiency";
Real HP(unit="kw")                 "Hydraulic power";
Real Q(unit="m^3/sec")             "flow rate";
Real d(unit="m")                   "Diameter of the jet";

// Parameters
 
 parameter Real D(unit="m")=1.45                    "Diameter of the wheel" ;
 parameter Real N(unit="rev/min")=375               "Shaft rotation" ;
 parameter Real h(unit="m")=200                     "Total head" ;
 parameter Real k(unit="")=0.9                      "Relative velocity coefficient" ;
 parameter Real thetha(unit="degree celsius")=165   "Deflection of the jet" ;
 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real P(unit="kW")=3750                   "Power trasmitted" ;
 parameter Real nm(unit="")=0.9                     "Mechanical efficiency" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

u=(pi*D*N)/60; 
hf=h*0.1;    //Losses is 0.1% of the total head
H=h-hf; 
V1=sqrt(2*g*H); 
S=u/V1; 
nh =2*S*(1-S)*(1-(k*cos(thetha*pi/180))); 
E=(u/g)*(V1-u)*(1 -(k*cos(thetha*pi/180))); 
n0=nm*nh; 
HP=P/n0; 
Q=(1000*HP)/(2*rho*g*H);
d=sqrt((4*Q)/(pi*V1));

//Answer may slightly vary due to rounding off error.
end Ex5_3;
