model Ex5_5

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V1(unit="m/sec")             "Velocity of the jet";
Real d(unit="m")                  "Diameter of the jet";
Real u(unit="m/sec")              "Peripherial Velocity";
Real D(unit="m")                  "Wheel diameter";
Real Q(unit="m^3/sec")            "Flow rate";
Real a(unit="m^2")                "Area of jet";
Real n(unit="")                   "Number of jets";
Real z(unit="")                   "Number of buckets";

// Parameters
 

 parameter Real Cv(unit="")=0.98                  "Coefficient of velocity" ;
 parameter Real rho(unit="kg/m^3")=1000           "Density of water" ;
 parameter Real n0(unit="")=0.87                  "Overall efficiency" ;
 parameter Real H(unit="m")=130                   "Head of water" ;
 parameter Real N(unit="rev/min")=200             "Speed of Pelton turbine" ;
 parameter Real P(unit="W")=8e06                  "Power developed by Pelton turbine" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

V1=Cv*sqrt(2*g*H);
u=0.46*V1;
D=(60*u)/(pi*N);
d=D/9;
Q=P/(n0*rho*g*H);
a=(pi/4)*d^2;
n=Q/(a*V1);
z=(D/(2*d))+15;

//Answer may slightly vary due to rounding off error.

end Ex5_5;
