model Ex5_6

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real P(unit="MW")                  "Power output of each unit";
Real HP(unit="kW")                 "Hydraulic power";
Real no(unit="")                   "Overall efficiency";
Real S(unit="")                    "Speed ratio";
Real u(unit="m/sec")               "Peripherial velocity";
Real V1(unit="m/sec")              "Velocity of the jet";
Real D(unit="m")                   "Diameter of wheel";
Real d(unit="m")                   "Diameter of jet";
Real z(unit="")                    "Number of bucket";
Real m(unit="")                    "Jet ratio";
Real L(unit="m")                   "Radial length of bucket";
Real B(unit="m")                   "Width of bucket";
Real Do(unit="m")                  "Depth of bucket";
Real nh(unit="")                   "Hydraulic efficiency";
Real nm(unit="")                   "Mechanical efficiency";

// Parameters
 
 parameter Real C(unit="MW")=100                     "Installed capacity" ;
 parameter Real n(unit="")=4                         "Number of units" ;
 parameter Real Q(unit="m^3/sec")=6.85               "Rated flow rate" ;
 parameter Real H(unit="m")=580                      "Rated head" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 parameter Real N(unit="rev/min")=428                "Rated speed" ;
 parameter Real n_(unit="")=2                        "number of jet" ;
 parameter Real k(unit="N/m^2")=0.95                 "Relative velocity coefficient" ;  //Assuming
 parameter Real thetha(unit="N/m^2")=160             "Deflection of the jet" ;  //Assuming
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

P=C/n;
HP=rho*g*Q*H/1000;
no=P*1e06/(rho*g*Q*H);
S=0.46;               //Assuming
V1=sqrt(2*g*H);
u=S*V1;
D=60*u/(pi*N);
d=sqrt(Q*4/(pi*V1*n_));
z=(D/(2*d))+15;
m=D/d;
L=2.5*d;
B=4*d;
Do=d;
nh =2*S*(1-S)*(1-(k*cos(thetha*pi/180)));
nm=no/nh;

end Ex5_6;
