model Ex5_7

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables


Real n0(unit="")                   "Overall efficiency";
Real Q(unit="MW")                  "Flow rate";
Real V1(unit="m/sec")              "Velocity of the jet";
Real S(unit="")                    "Speed ratio";
Real u(unit="m/sec")               "Peripherial velocity";
Real D(unit="m")                   "Diameter of wheel";
Real d(unit="m")                   "Diameter of jet";
Real a(unit="m^2")                 "Area of jet";
Real n(unit="")                    "Number of jets";
Real wT(unit="")                   "Specific speed of turbine";
Real w(unit="")                    "Specific speed";


// Parameters
 
 parameter Real H(unit="m")=120                       "Head" ;
 parameter Real N(unit="rev/min")=200                 "Speed of wheel" ;
 parameter Real P(unit="W")=4.5e06                    "Power developed" ;
 parameter Real rho(unit="kg/m^3")=1000               "Density of water" ;

 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

n0=0.8;                               //Assuming
Q=P/(n0*rho*g*H);
V1=sqrt(2*g*H);
S=0.42;                               //Assuming
u=S*V1;
D=60*u/(pi*N);
d=D/8;
a=(pi/4)*d^2;
n=Q/(a*V1);
wT=w*((P/rho)^0.5)/((g*H)^(5/4));
w=(2*N*pi)/60;

end Ex5_7;
