model Ex6_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real u1(unit="m/sec")                    "Peripheral velocity";
Real V1f(unit="m/sec")                   "Velocity of flow at inlet";
Real V1w(unit="m/sec")                   "Velocity of whirl at inlet";
Real alpha1(unit="degree celsius")       "Guide vane angle";
Real D1(unit="m")                        "Diameter of the wheel at inlet";
Real Q(unit="m^3/sec")                   "Flow rate";

// Parameters
 
 parameter Real H(unit="m")=8                 "Head" ;
 parameter Real nh(unit="")=0.85              "Hydraulic efficiency" ;
 parameter Real N(unit="RPM")=150             "Runner speed" ;
 parameter Real n0(unit="")=0.8               "Overall efficiency" ;
 parameter Real rho(unit="kg/m^3")=1000       "Density of water" ;
 parameter Real P(unit="W")=150e03            "Power developed" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

u1=0.96*sqrt(2*g*H);
V1f=0.36*sqrt(2*g*H);
V1w=nh*g*H/u1;
tan(alpha1*pi/180)=V1f/V1w;
D1=60*u1/(pi*N);
Q=P/(rho*g*H*n0);



end Ex6_1;
