model Ex6_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real u1(unit="m/sec")                    "Peripheral velocity at inlet";
Real u2(unit="m/sec")                    "Peripheral velocity at outlet";
Real V1w(unit="m/sec")                   "Velocity of whirl at inlet";
Real V2w(unit="m/sec")                   "Velocity of whirl at inlet";
Real E(unit="m")                         "Euler's head";
Real H(unit="m")                         "Head";
Real PI(unit="kW")                       "Power Input";
Real PO(unit="kW")                       "Power output";

// Parameters
 
 parameter Real w(unit="rad/sec")=25                 "Angular velocity" ;
 parameter Real R1(unit="m")=0.300                   "Inlet radius" ;
 parameter Real R2(unit="m")=0.150                   "Outlet radius" ;
 parameter Real V1(unit="m/sec")=6                   "Inlet absolute velocity" ;
 parameter Real V2(unit="m/sec")=3                   "Exit absolute velocity" ;
 parameter Real n0(unit="")=0.8                      "Overall efficiency" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 parameter Real Q(unit="m^3/sec")=0.05               "Flow rate" ;
 parameter Real nH(unit="")=0.9                      "Hydraulic efficiency" ;
 parameter Real alpha1(unit="degree celsius")=30     "Inlet guide blade angle" ;
 parameter Real alpha2(unit="degree celsius")=80     "Exit guide blade angle" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

u1=w*R1;
u2=w*R2;
V1w=V1*cos(alpha1*pi/180);
V2w=V2*cos(alpha2*pi/180);
E=(u1*V1w-u2*V2w)/g;
H=E/nH;
PI=rho*g*Q*H/1000;
PO=n0*PI;


end Ex6_2;
