model Ex6_5

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V1f(unit="m/sec")                    "Velocity of flow at inlet";
Real V1w(unit="m/sec")                    "Velocity of whirl at outlet";
Real T(unit="N-m")                        "Torque";
Real w(unit="rad/sec")                    "Specific speed";
Real SP(unit="W")                         "Shaft power";
Real n0(unit="")                          "Overall efficiency";
Real wT(unit="")                          "Specific speed of turbine";
Real Ns(unit="")                          "Speed of turbine";

// Parameters
 
 parameter Real R1(unit="m")=0.6                    "Radius at inlet" ;
 parameter Real B1(unit="m")=0.03                   "Width of vanes" ;
 parameter Real Q(unit="m^3/sec")=0.4               "Flow rate" ;
 parameter Real alpha1(unit="")=20                  "Guide vane angle" ;
 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real N(unit="rpm")=1260                  "Runner speed" ;
 parameter Real HP(unit="W")=360e03                 "Hydraulic power" ;
 parameter Real H(unit="m")=92                      "Head" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

V1f=Q/(pi*2*R1*B1);
tan(alpha1*pi/180)=V1f/V1w;
T=Q*rho*V1w*R1;
w=2*N*pi/60;
SP=T*w;
n0=SP/HP;
wT=w*((SP/rho)^0.5)/((g*H)^(5/4));
Ns=(N*sqrt(SP/1000))/(H^(5/4));


//Answer may slightly vary due to rounding off error.
end Ex6_5;
