model Ex7_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real D(unit="m")                               "Mean diameter";
Real w(unit="rad/sec")                         "Specific speed of the pump";
Real u(unit="m/sec")                           "Speed of the pump";
Real V1w(unit="m/sec")                         "Whirl velocity at inlet";
Real Q(unit="m^3/sec")                         "Flow rate";
Real Vf(unit="m/sec")                          "Flow velocity";
Real beta1(unit="degree celsius")              "Runner blade inlet angle";
Real beta2(unit="degree celsius")              "Runner blade outlet angle";

// Parameters
 
 parameter Real Dt(unit="m")=4.5             "Tip diameter" ;
 parameter Real Dh(unit="m")=2               "Hub diameter" ;
 parameter Real rho(unit="kg/m^3")=1000      "Density of water" ;
 parameter Real N(unit="rpm")=140            "Rotational speed of the pump" ;
 parameter Real nh(unit="")=0.94             "Hydraulic efficiency" ;
 parameter Real n0(unit="")=0.88             "Overall efficiency" ;
 parameter Real P(unit="W")=21e06            "Power developed by turbine" ;
 parameter Real H(unit="m")=21.8             "Head" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

D=(Dt+Dh)/2;
w=2*pi*N/60;
u=w*D/2;
V1w=nh*g*H/u;
Q=P/(n0*rho*g*H);
Vf=Q*4/(pi*(Dt^2-Dh^2));
tan(beta1*pi/180)=Vf/(u-V1w);
tan(beta2*pi/180)=Vf/u;

//Answer may slightly vary due to rounding off error.
end Ex7_1;
