model Ex7_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real D(unit="m")                               "Mean diameter";
Real u(unit="m/sec")                           "Speed of the pump";
Real V1w(unit="m/sec")                         "Whirl velocity at inlet";
Real Q(unit="m^3/sec")                         "Flow rate";
Real Vf(unit="m/sec")                          "Flow velocity";
Real E(unit="m")                               "Euler's head";
Real Ep(unit="kW")                              "Euler's power";
Real beta2(unit="degree celsius")              "Runner blade outlet angle";

// Parameters
 
 parameter Real Dt(unit="m")=2                 "Tip diameter" ;
 parameter Real Dh(unit="m")=0.8               "Hub diameter" ;
 parameter Real rho(unit="kg/m^3")=1000        "Density of water" ;
 parameter Real N(unit="rpm")=250              "Rotational speed of the pump" ;
 parameter Real alpha1(unit="")=42             "Guide vane angle" ;
 parameter Real beta1(unit="")=148             "Runner blade inlet angle" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

D=(Dt+Dh)/2;
u=pi*D*N/60;
(tan((180-beta1)*pi/180))*(u-V1w)=tan(alpha1*pi/180)*V1w;
Vf=V1w*tan(alpha1*pi/180);
Q=(pi/4)*((Dt^2-Dh^2)*Vf); 
E=(u*V1w)/g;
Ep=(rho*g*Q*E)*1e-03/1000; 
tan(beta2*pi/180)=Vf/u;

//Answer may slightly vary due to runding off error.
end Ex7_2;
