model Ex7_5

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real H(unit="m")                              "Head";
Real V1(unit="m/sec")                         "Velocity";
Real u(unit="m/sec")                          "Peripheral velocity";
Real Vr1(unit="m/sec")                        "Relative velocity at inlet";
Real beta1(unit="degree celsius")             "Runner blade inlet angle";
Real V1w(unit="m/sec")                        "Whirl velocity at inlet";
Real E(unit="m")                              "Euler's head";


// Parameters
 
 parameter Real h(unit="m")=35                            "Head" ;
 parameter Real D(unit="m")=2                             "Diameter" ;
 parameter Real N(unit="rpm")=145                         "Rotational speed of the turbine" ;
 parameter Real alpha1(unit="degree celsius")=30          "Guide vane angle" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

H=0.93*h;        //loss is 7% of the head
V1=sqrt(2*g*H);
u=pi*D*N/60;
Vr1^2=V1^2+u^2-(2*u*V1*cos(alpha1*pi/180));
u^2=(Vr1^2)+(V1^2)-(2*Vr1*V1*cos((180-beta1)*pi/180));
V1w=V1*cos(alpha1*pi/180);
E=u*V1w/g;

//Answer may vary due to rounding off error.
end Ex7_5;
