model Ex7_8

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real w(unit="rad/sec")                        "Angular velocity";
Real wT(unit="")                              "Specific speed";
Real Ns(unit="")                              "Specific speed";
Real n0(unit="")                              "Overall efficiency";


// Parameters
 
 parameter Real P(unit="W")=26.1e06                  "Power" ;
 parameter Real H(unit="m")=587.3                    "Head" ;
 parameter Real N(unit="rpm")=428                    "Rotational speed of the turbine" ;
 parameter Real Q(unit="m^3/sec")=6.85               "FLow rate" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

w=2*pi*N/60;
wT=(w*sqrt(P/rho))/((g*H)^(5/4));
Ns=N*sqrt(P/1000)/(H^(5/4));
n0=P/(rho*g*Q*H);

//Book answer is wrong.
end Ex7_8;
