model Ex8_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real w(unit="rad/sec")                    "Specific speed";
Real Q(unit="m^3/sec")                    "Flow rate";
Real H(unit="m")                          "Head";
Real wp(unit="")                          "Specific speed of the pump";

// Parameters
 
 parameter Real Q0(unit="l/min")=1890               "Flow rate" ;
 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real N(unit="rpm")=3600                  "Rotational speed of the pump" ;
 parameter Real P(unit="Pascal")=448e03             "Pressure head" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


w =(2*N*pi)/60;
Q=Q0/(60*1000);
H=P/(rho*g);
wp=((w*(sqrt(Q)))/((g*H)^(3/4)));

end Ex8_1;
