model Ex8_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real z1(unit="m")                          "Elevation";

// Parameters
 
 parameter Real Patm(unit="Pascal")=101e03          "Atmospheric pressure" ;
 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real NPSH(unit="m")=7.4                  "Net positive suction head" ;
 parameter Real Pv(unit="Pascal")=1666              "Pressure head" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

z1=((Patm-Pv)/(rho*g))-NPSH;

end Ex8_2;
