model Ex8_6

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real A(unit="m^2")                      "Area";
Real Vf(unit="m/sec")                   "Velocity of flow";
Real D(unit="m")                        "Mean diameter";
Real w(unit="rad/sec")                  "Specific speed";
Real u(unit="m/sec")                    "Peripherial Velocity";
Real H1(unit="m")                       "Theoretical head";
Real P(unit="kW")                       "Required power";

// Parameters 

 parameter Real Dh(unit="m")=300e-03                  "Outer diameter of blade" ;
 parameter Real Dt(unit="m")=150e-03                  "Inner diameter of blade" ;
 parameter Real rho(unit="kg/m^3")=1000               "Density of water" ;
 parameter Real alpha1(unit="degree celsius")=75      "Guide blade angle" ;
 parameter Real beta2(unit="degree celsius")=70       "Exit blade angle" ;
 parameter Real Q(unit="kg/sec")=150e-03              "Discharge of the pump" ;
 parameter Real N(unit="rev/min")=500                 "Speed of the impeller" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

A=(pi/4)*(Dh^2-Dt^2);
Vf=Q/A;
D=(Dh+Dt)/2;
w=2*pi*N/60;
u=w*D/2;
H1=(u^2/g)-((u*Vf)/g)*((1/tan(alpha1*pi/180))+(1/tan(beta2*pi/180)));
P=rho*g*Q*H1/1000;

//Answer may slightly vary due to runding off error.
end Ex8_6;
