model Ex8_7

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real A(unit="m^2")                     "Area";
Real V(unit="m/sec")                   "Velocity in the suction pipe";
Real h1(unit="m")                      "Height";
Real z1(unit="m")                  "Maximum height that the pump can be located above the water surface without cavitation";

// Parameters 

 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real Pv(unit="Pascal")=1666              "Pressure" ;
 parameter Real Patm(unit="Pascal")=101e03          "Atmospheric pressure" ;
 parameter Real Q(unit="m^3/sec")=3.5e-03           "Discharge of the pump" ;
 parameter Real NPSH(unit="m")=4.5                  "Net positive suction head" ;
 parameter Real d(unit="m")=0.1                     "Diameter of suction pipe" ;
 parameter Real k(unit="")=20                       "Minor loss coefficient" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


A=(pi/4)*d^2;
V=Q/A;
h1=(k*V^2)/(2*g);
z1=(Patm/(rho*g))-h1-(Pv/(rho*g))-NPSH;


end Ex8_7;
