model Ex9_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real As(unit="m^2")                    "Area of suction side";
Real Vs(unit="m/sec")                  "Velocity at suction side";
Real Ad(unit="m^2")                    "Area of discharge side";
Real Vd(unit="m/sec")                  "Velocity at discharge side";
Real H(unit="m")                       "Total head across the pump";

// Parameters
 
 parameter Real Ps(unit="Pascal")=54e03            "Suction head pressure" ;
 parameter Real Pd(unit="Pascal")=160e03           "Delivery head pressure" ;
 parameter Real Ds(unit="m")=15e-02                "Diameter of suction side" ;
 parameter Real Dd(unit="m")=12.5e-02              "Diameter of Delivery side" ;
 parameter Real rho(unit="kg/m^3")=1000            "Density of water" ;
 parameter Real Q(unit="m^3/sec")=37.5e-03         "Flow rate" ;
 parameter Real Z(unit="m")=0                      "Datum" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

As=(pi/4)*Ds^2;
Vs=Q/As;
Ad=(pi/4)*Dd^2;
Vd=Q/Ad;
H=((Ps/(rho*g))+((Vs^2)/(2*g))+Z)+((Pd/(rho*g))+((Vd^2)/(2*g))+Z);

end Ex9_2;
