/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_1 Page:374
//Title:Analyzing an Ideal Vapor-Compression Refrigeration Cycle
//===============================
package Ex10_1
  model Ex10_1_a
  //To find the compressor power
  
      //parameter selection
      parameter Real m(unit = "kg/s") = 0.08 "mass flow rate";
      parameter Real h1(unit = "kJ/kg") = 247.23 "specific enthalpy at state 1";    
                                                            /*From Table A-10 at T=273 K 
                                                            for saturated vapour. 
                                                            Appendix Pg:A-19*/
      parameter Real h2s(unit = "kJ/kg") = 264.7 "specific enthalpy at state 2s";    
                                                            /*From Table A-12 interpolating 
                                                            at T=299 K and p=6.853 bar. 
                                                            Appendix Pg:A-22*/
      //===============================
      
      //variable selection
      Real Wc(unit = "kW") "compressor work input";
      //===============================
      
      //equation selection
      equation
        Wc = m * (h2s - h1);     //From Eq. 10.4, Pg:372
  end Ex10_1_a;
  //===============================

  model Ex10_1_b
  //To find refrigeration capacity
      
      //===============================
      extends Ex10_1_a;
      //===============================
      
      //parameter selection
      parameter Real h3(unit="kJ/kg")=85.75"specific enthalpy at state 3";    
                                                           /*From Table A-10 at T=299 K for 
                                                           saturated liquid. Appendix Pg:A-19*/
      //===============================
      
      //variable selection
      Real h4(unit="kJ/kg")"specific enthalpy at state 4";
      Real Qin(unit="ton")"refrigeration capacity";
      //===============================
      
      //equation selection
      equation
        h3=h4;
        Qin=m*60*(h1-h4)/211;     //From Eq. 10.3, Pg:372
                                  //Multiplying by 60 to convert into second
                                  //Dividing by 211 to convert into ton
      
  end Ex10_1_b;
  //===============================

  model Ex10_1_c
  //To find coefficient of performance
  
      //===============================
      extends Ex10_1_a;
      extends Ex10_1_b;
      //===============================
      
      //variable seection
      Real b(unit="-")"coefficient of performance";
      //===============================
      
      //equation selection
      equation
        b=(h1-h4)/(h2s-h1);       //Coefficient of performance
  end Ex10_1_c;
  //===============================

  model Ex10_1_d
  //To find coefficient of performance of a Carnot refrigeration cycle
      
      //parameter selection
      parameter Real Tc(unit="K")=273"temperature of the cold region";
      parameter Real Th(unit="K")=299"temperature of the warm region";
      //===============================
      
      //variable selection
      Real bmax(unit="-")"maximum coefficient of performance";
      //===============================
      
      //equation selection
      equation
        bmax=Tc/(Th-Tc);         //Maximum coefficient of performance
      
  end Ex10_1_d;
  //===============================
end Ex10_1;
