/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_4 Page:389
//Title:Analyzing an Actual Vapor-Compression Heat Pump Cycle
//===============================
package Ex10_4
  model Ex10_4_a
  //To find compressor power
    
      //parameter selection
      parameter Real m(unit = "kg/s") = 0.2 "mass flow rate";
      parameter Real h1(unit = "kJ/kg") = 242.54 "specific enthalpy at state 1";    
                                                            /*From Table in Example 10.4 
                                                            at T=-8 C. Pg:389*/
      parameter Real h2(unit = "kJ/kg") = 280.19 "specific enthalpy at state 2";   
                                                            /*From Table in Example 10.4 at 
                                                            T=50 C and p=10 bar. Pg:389*/
      //===============================
      
      //variable selection
      Real Wc(unit = "kW") "compressor power";
      //===============================
      
      //equation selection
      equation
        Wc = m * (h2 - h1);               //From Eq. 10.4, Pg:372
  end Ex10_4_a;

  model Ex10_4_b
  //To find isentropic compressor efficiency
  
      //===============================
      extends Ex10_4_a;
      //===============================
      
      //parameter selection
      parameter Real h2s(unit="kJ/kg")=274.18"specific enthalpy at state 2s";
                                                            /*From Table A-12 interpolating 
                                                            at p=10 bar and s=0.9239 kJ/kg.K. 
                                                            Appendix Pg:A-23*/
      //===============================
      
      //variable selection
      Real nc(unit="-")"compressor efficiency";
      //===============================
      
      //equation selection
      equation
        nc = (h2s - h1) / (h2 - h1);        //Isentropic compressor efficiency
  end Ex10_4_b;
  //===============================

  model Ex10_4_c
  //To find heat transfer rate provided to the building
  
      //===============================
      extends Ex10_4_a;
      extends Ex10_4_b;
      //===============================
      
      //parameter selection
      parameter Real h3(unit="kJ/kg")=105.29"specific enthalpy at state 3";    
                                                          /*From Table in Example 10.4 
                                                          at p=10 bar. Pg:389*/
      //===============================
      
      //variable selection
      Real Qout(unit="kW")"heat trasnfer rate provided to the building";
      //===============================
      
      //equation selection
      equation
        Qout=m*(h2-h3);      //From Eq. 10.5, Pg:373
  
  end Ex10_4_c;
  //===============================

  model Ex10_4_d
  //To find coefficient of performance
  
      //===============================
      extends Ex10_4_a;
      extends Ex10_4_b;
      extends Ex10_4_c;
      //===============================
      
      //variable selection
      Real gamma(unit="-")"heat pump coefficient of performance";
      //===============================
      
      //equation selection
      equation
        gamma=Qout/Wc;          //Heat pump coefficient of performance
      
  end Ex10_4_d;
  //===============================

  model Ex10_4_e
  //To find total cost of electricity
  
      //===============================
      extends Ex10_4_a;
      //===============================
      
      //parameter selection
      parameter Real h(unit="hour")=80"hours of operation";
      parameter Real cost(unit="$/kW.h")=0.15"cost of electricity";
      //===============================
      
      //variable selection
      Real tot_cost(unit="$")"total cost of electricity";
      //===============================
      
      //equation selection
      equation
        tot_cost=Wc*h*cost;
  
  end Ex10_4_e;
  //===============================
end Ex10_4;
