/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_10 Page:441
//Title:Estimating Mixture Pressure by Alternative Means
//===============================
package Ex11_10
  model Ex11_10_a
  //To find pressure using ideal gas equation of state
    
      //parameter selection 
      parameter Real n1(unit = "kmol") = 0.18 "moles of methane";
      parameter Real n2(unit = "kmol") = 0.274 "moles of butane";
      parameter Real V(unit = "m3") = 0.241 "volume occupied by mixture";
      parameter Real T(unit = "C") = 238 "temperature of the mixture";
      final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
      final constant Real M(final unit = "kg/kmol") = 28 "molecular mass of nitrogen";
                                                          /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real v(unit = "m3/kmol") "specific volume of the mixture";
      Real p(unit = "bar") "pressure exerted by the mixture";
      //===============================
      
      //equation selection
      equation
        v = V / (n1 + n2);
        p = R * (T + 273.15) / v * (1 / 10 ^ 5);      //Ideal gas equation of state
                                                      //Dividing by 10^5 to convert into bar
                                                      //Adding 273.15 to convert into Kelvin scale
  
    end Ex11_10_a;
    //===============================
  
    model Ex11_10_b
    //To use Kay's rule and compressibility chart
    
      //===============================
      extends Ex11_10_a;
      //===============================
      
      //parameter selection
      parameter Real Tc1(unit = "K") = 191 "critical temperature for methane";
      parameter Real pc1(unit = "bar") = 46.4 "critical pressure for methane";    
                                                                    /*From Table A-1 for methane. 
                                                                    Appendix Pg A-2*/
      parameter Real Tc2(unit = "K") = 425 "critical temperature for butane";
      parameter Real pc2(unit = "bar") = 38.0 "critical pressure for butane";  
                                                                    /*From Table A-1 for butane. 
                                                                    Appendix Pg:A-2*/
      parameter Real Z(unit = "-") = 0.88 "compressibility factor";   
                                                                    /*From Fig. A-2 for TR=1.54 
                                                                    and vR=0.794. Appendix Pg:A-98*/
      //===============================
      
      //variable selection
      Real y1(unit = "-") "mole fraction of methane";
      Real y2(unit = "-") "mole fraction of butane";
      Real Tc(unit = "K") "critical temperature of the mixture";
      Real pc(unit = "bar") "critical pressure of the mixture";
      Real TR(unit = "-") "reduced temperature of mixture";
      Real vR(unit = "-") "reduced specific volume of mixture";
      Real pK(unit = "bar") "pressure exerted by the mixture";
      //===============================
      
      //equation selection
      equation
        y1 = n1 / (n1 + n2);
        y2 = n2 / (n1 + n2);                      //Mole fraction
        Tc = y1 * Tc1 + y2 * Tc2;
        pc = y1 * pc1 + y2 * pc2;                 //From Eq.11.97, Pg:439
    
        TR = (T + 273.15) / Tc;                   //Reduced temperature
                                                  //Adding 273.15 to convert into Kelvin scale
    
        vR = v * pc * 10 ^ 5 / (R * Tc);          //Dividing by 10^5 to convert into Pa
                                                  //Reduced specific volume
        
        pK = Z * R * (T + 273.15) / (v * 10 ^ 5); //Ideal gas equation of state with compressibility factor
                                                  //Dividing by 10^5 to convert into bar
                                                  //Adding 273.15 to convert into Kelvin scale

  end Ex11_10_b;
  //===============================

  model Ex11_10_c
  //To find pressure using van der Waals equation
  
      //===============================
      extends Ex11_10_a;
      extends Ex11_10_b;
      //===============================
      
      //parameter selection
      parameter Real a1(unit = "m6/kmol2") = 2.293 "van der Waals equation constant for methane";
      parameter Real b1(unit = "m3/kmol") = 0.0428 "van der Waals equation for methane";    
                                                                      /*From Table A-24 for methane. 
                                                                      Appendix Pg:A-45*/
      parameter Real a2(unit = "m6/kmol2") = 13.86 "van der Waals equation constant for butane";
      parameter Real b2(unit = "m3/kmol") = 0.1162 "van der Waals equation for butane";   
                                                                      /*From Table A-24 for butane. 
                                                                      Appendix Pg:A-45*/
      //===============================
      
      //variable selection
      Real pv(unit = "bar") "pressure exerted by the mixture";
      Real a(unit = "m6/kmol2") "van der Waals constant for mixture";
      Real b(unit = "m3/kmol") "van der Waals constant for mixture";
      //===============================
      
      //equation selection
    equation
      a = (y1 * a1 ^ 0.5 + y2 * a2 ^ 0.5) ^ 2;
      b = y1 * b1 + y2 * b2;                                           //From Eq. 11.96, Pg:439
      pv = R * (T + 273.15) / (v - b) * (1 / 10 ^ 5) - a / v ^ 2;      //Van der Waals equation of state
  end Ex11_10_c;
  //===============================

  model Ex11_10_d
  //To find pressure using rule of addtive pressures
  
        //===============================
        extends Ex11_10_a;
        extends Ex11_10_b;
        //===============================
        
        //parameter selection
        parameter Real Z1(unit = "-") = 1.0 "compressibility factor for methane";
                                                          /*From Fig. A-2 for TR=2.69 and vR=3.91. 
                                                          Appendix Pg:A-98*/
        parameter Real Z2(unit = "-") = 0.8 "compressibility factor for butane";
                                                          /*From Fig. A-2 for TR=1.2 and vR=0.95. 
                                                          Appendix Pg:A-98*/
        //===============================
        
        //variable selection
        Real TR1(unit = "-") "reduced temperature for methane";
        Real vR1(unit = "-") "reduced specific volume for methane";
        Real TR2(unit = "-") "reduced temperature for butane";
        Real vR2(unit = "-") "reduced specific volume for butane";
        Real Zd(unit = "-") "compressibility factore for the mixture";
        Real pp(unit = "bar") "pressure exerted by thr mixture";
        //===============================
        
        //equation selection
      equation
        TR1 = (T+273.15)/ Tc1; 
        TR2 = (T +273.15)/ Tc2;                       //Reduced temperature
                                                      //Adding 273.15 to convert into Kelvin scale
        vR1 = V / n1 * pc1 * 10 ^ 5 / (R * Tc1); 
        vR2 = V / n2 * pc2 * 10 ^ 5 / (R * Tc2);      //Reduced specific volume
                                                      //Dividing by 10^5 to convert into Pa
        Zd = y1 * Z1 + y2 * Z2;                       //From Eq. 11.99(b), Pg:340
        pp = Zd * R * (T + 273.15) / (v * 10 ^ 5);    //Ideal gas equation of state with compressibility factor
                                                      //Dividing by 10^5 to convert into bar
                                                      //Adding 273.15 to convert into Kelvin scale
  end Ex11_10_d;
  //===============================
end Ex11_10;
