/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_4 Page:416
//Title:Applying the Clapeyron Equation
//===============================
package Ex11_4
  model Ex11_4_a
  //To find specific enthalpy difference
  
      //parameter selection
      parameter Real dpdT_sat(unit="N/m2.K")=3570"slope of tangent"; //dpdT_sat=(del p/del T)sat
                                                                     /*From Fig. E11.4  for 
                                                                     saturation pressure vs temperature curve 
                                                                     at T=100 C. Pg:416*/ 
      parameter Real vg(unit="m3/kg")=1.673"specific volume of saturated vapour";
      parameter Real vf(unit="m3/kg")=1.0435e-3"specific volume of saturated liquid";
                                                                      /*From Table A-2 at T=100 C. 
                                                                      Appendix Pg:A-4*/
      parameter Real T(unit="C")=100"temperature";
      //===============================
      
      //variable selection
      Real hfg(unit="kJ/kg")"specific enthalpy difference";  //hfg=hg-hf
      //===============================
      
      //equation selection
      equation
        hfg=(T+273.15)*(vg-vf)*dpdT_sat*(1/10^3);   //From Eq. 11.40, Pg:415
                                                    //Adding 273.15 to convert in Kelvin scale
                                                    //Dividing by 10^3 to convert into kJ
                                                  
  end Ex11_4_a;
  //===============================

  model Ex11_4_b
  //To find specific internal energy difference
  
      //parameter selection
      parameter Real hfg(unit="kJ/kg")=2256"specific enthalpy difference";     //hfg=hg-hf
                                                                         /*Obtained from IT result for T=100 C*/ 
      parameter Real psat(unit="N/m2")=1.014e5"saturation pressure";
      parameter Real vg(unit="m3/kg")=1.673"specific volume of saturated vapour";
      parameter Real vf(unit="m3/kg")=1.0435e-3"specific volume of saturated liquid";
                                                                         /*From Table A-2 at T=100 C. 
                                                                         Appendix Pg:A-4*/
      parameter Real T(unit="C")=100"temperature";
      //===============================
      
      //variable selection
      Real ufg(unit="kJ/kg")"specific internal energy difference";      //ufg=ug-uf
      //===============================
      
      //equation selection
      equation
        ufg=hfg-psat*(vg-vf)*(1/10^3);   //From Eq. 11.39, Pg:414
                                         //Dividing by 10^3 to convert into kJ
  end Ex11_4_b;
  //===============================

  model Ex11_4_c
  //To find specific entropy difference
  
      //===============================
      extends Ex11_4_b;
      //===============================
      
      //variable selection
      Real sfg(unit="kJ/kg.K")"specific entropy difference";      //sfg=sg-sf
      //===============================
      
      //equation selection
      equation
        sfg=hfg/(T+273.15);   //From Eq. 11.38, Pg:414
                              //Adding 273.15 to convert in Kelvin scale
  end Ex11_4_c;
  //===============================
end Ex11_4;
