/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_1 Page:460
//Title:Converting Mole Fractions to Mass Fractions
//===============================
package Ex12_1
  model Ex12_1_a
  //To find apparent molecular weight of the mixture
  
    //parameter selection
      parameter Real[4] n(each unit = "-") = {0.08, 0.11, 0.07, 0.74} "molar fraction of CO2,H2O,O2,N2";
      parameter Real[4] M(each unit = "kg/kmol") = {44.01, 18.02, 32.00, 28.01} "moleular mass of CO2,H2O,O2,N2";
                                                                              /*From Table A-1, Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real[4] m(each unit = "kg/kmol") "apparent molecular weight of CO2,H2O,O2,N2";
      Real M_tot(unit = "kg/kmol") "apparent molecular weight of the mixture";
      //===============================
      
      //equation selection
      equation
        for i in 1:4 loop
          m[i] = n[i] * M[i];
        end for;
        M_tot = m[1] + m[2] + m[3] + m[4];     //From Eq. 12.9, Pg:459
  end Ex12_1_a;
  //===============================
  model Ex12_1_b
  //To determine mass fractions
    
      //===============================
      extends Ex12_1_a;
      //===============================
      
      //variable selection
      Real [4]mf(each unit = "%") "mass fraction of CO2,H2O,O2,N2";
      //===============================
      
      //equation selection
      equation
        for j in 1:4 loop
          mf[j] = m[j] / M_tot * 100;
        end for;
  end Ex12_1_b;
  //===============================
end Ex12_1;
