/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_13 Page:495
//Title:Considering an Evaporative Cooler
//===============================
package Ex12_13
  model Ex12_13_a
  //To find mass flow rate of water
  
      //parameter selection
      parameter Real AV1(unit = "ft3/min") = 5000 "flow rate of dry air at inlet";
      parameter Real p(unit = "atm") = 1 "total pressure";
      parameter Real va1(unit = "ft3/lb(dry air)") = 14.2 "speific volume of dry air";      
                                                                /*Evaluated using ideal gas 
                                                                eqation of state*/
      parameter Real phi1(unit = "-") = 0.10 "relative humidity of dry air";
      parameter Real pg1(unit = "lbf/in2") = 0.9503 "saturation pressure at inlet dry air";
                                                                /*From Table A-2E at T=70 F. 
                                                                Appendix Pg:A-51*/
      parameter Real cpa(unit = "Btu/lb.R") = 0.24 "constant pressure specific heat of dry air";
                                                                /*From Table A-21E for air. 
                                                                Appendix Pg:A-88*/
      parameter Real T1(unit = "F") = 100 "inlet temperature";
      parameter Real T2(unit = "R") = 70 "exit temperature";
      parameter Real hf(unit = "Btu/lb") = 38.1 "specific enthalpy of water entering";       
                                                                /*From Table A-2E at T=70 F. 
                                                                Appendix Pg:A-51*/
      parameter Real hg1(unit = "Btu/lb") = 1105 "saturation vapour enthalpy at inlet"; 
                                                                /*From Table A-2E at T=100 F. 
                                                                Appendix Pg:A-51*/
      parameter Real hg2(unit = "Btu/lb") = 1092 "saturation vapour enthalpy at exit"; 
                                                                /*From Table A-2E at T=70 F. 
                                                                Appendix Pg:A-51*/
      //===============================
      
      //variable selection
      Real mw(unit = "lb(water)/h") "mass flow rate of the water to the soaked pad";
      Real ma(unit = "lb(dry air)/min") "mass flow rate of dry air";
      Real omega1(unit = "lb(vapour)/lb(dry air)") "humidity ratio at inlet";
      Real omega2(unit = "lb(vapour)/lb(dry air)") "humidity ratio at at exit";
      Real pv1(unit = "lbf/in2") "partial pressure of water vapour";
      //===============================
      
      //equation selection
      equation
        mw = ma * 60 * (omega2 - omega1);                    //From conservation of mass
                                                             //Multiplying by 60 to convert into per h
        ma = AV1 / va1;                                      //Mass flow rate
        pv1 = phi1 * pg1;                                    //Relative pressure
        omega1 = 0.622 * pv1 / (p * 14.6959 - pv1);          //From Eq.12.43, Pg:476
                                                             //Multiplying by 14.6959 to convert into lbf/in^2
        omega2 = (cpa * (T1 - T2) + omega1 * (hg1 - hf)) / (hg2 - hf);
                                                             //Reduced equation of Eq.12.55, Pg:487
        
  end Ex12_13_a;
  //===============================
  model Ex12_13_b
  //To find relative humidity at exit
  
      //===============================
      extends Ex12_13_a;
      //===============================
      
      //parameter selection
      parameter Real pg2(unit="lbf/in2")=0.3632"saturation pressure at exit";    
                                                                /*From Table A-2E at T=70 F. 
                                                                Appendix Pg:A-51*/
      //===============================
      
      //variable selection
      Real pv2(unit="lbf/in2")"partial water vapour pressure at exit";
      Real phi2(unit="-")"relative humidity at exit";
      //===============================
      
      //equation selection
      equation
        omega2=0.622*pv2/(p*14.6959-pv2);     //Humidity ratio
                                              //Multiplying by 14.6959 to convert into lbf/in^2
        phi2=pv2/pg2;                         //Relative pressure
  end Ex12_13_b;
  //===============================
end Ex12_13;
