/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_14 Page:497
//Title:Analyzing Adiabatic Mixing of Two Moist Air Streams
//===============================
package Ex12_14
  model Ex12_14_a
  //To find humidity ratio of exit stream
  
      //parameter selection
      parameter Real AV1(unit = "m3/min") = 142 "flow rate of stream 1";
      parameter Real AV2(unit = "m3/min") = 425 "flow rate of stream 2";
      parameter Real omega1(unit = "kg(vapour)/kg(dry air)") = 0.002 "humidity ratio of stream 1";
      parameter Real phi2(unit = "-") = 0.50 "relative humidity at stream 2";
      parameter Real va1(unit = "m3/kg(dry air)") = 0.79 "specific volume at stream 1";    
                                                                    /*From Fig. A-9 at omega=0.002 
                                                                    and T=5 C. Appendix Pg:A-106*/
      
      parameter Real va2(unit = "m3/kg(dry air)") = 0.855 "specific volume at stream 2"; 
      parameter Real omega2(unit = "kg(vapour)/kg(dry air)") = 0.0094 "humidity ratio at stream 2";
                                                                    /*From Fig. A-9 at phi=50% 
                                                                    and T=24 C. Appendix Pg:A-106*/ 
      //===============================
      
      //variable selection
      Real omega3(unit = "kg(vapour)/kg(dry air)")"humidity ratio at exit stream";
      Real ma1(unit = "kg(dry air)/min") "mass flow rate at stream 1";
      Real ma2(unit = "kg(dry air)/min") "mass flow rate at stream 2";
      Real ma3(unit = "kg(dry air)/min") "mass flow rate at exit stream ";
      //===============================
      
      //equation selection
      equation
        ma1 + ma2 = ma3;                             //Conservation of mass
        omega1 * ma1 + omega2 * ma2 = omega3 * ma3;  //From Eq.12.56(b),Pg:497
        ma1 = AV1 / va1;
        ma2 = AV2 / va2;                             //Mass flow rate
  end Ex12_14_a;
  //===============================
  
  model Ex12_14_b
  //To find temperature of the exit
      
      //===============================
      extends Ex12_14_a;
      //===============================
      
      //parameter selection
      parameter Real hag_1(unit="kJ/kg(dry air)")=10"specific enthalpy of air and satuarted vapour at state 1";    
                                                                //hag_1=(ha+w.hg)1
                                                                /*From Fig. A-9 at omega=0.002 
                                                                and T=5 C. Appendix Pg:A-106*/
      parameter Real hag_2(unit="kJ/kg(dry air)")=47.8"specific enthalpy of air and saturated vapour value at state 2";       
                                                                //hag_2=(ha+w.hg)2
                                                                /*From Fig. A-9 at phi=50% and 
                                                                T=24 C. Appendix Pg:A-106*/   
      //===============================
       
      //variable selection
      Real hag_3(unit="kJ/kg(dry air)")"specific enthalpy of air and saturated vapour value at state 3";       
                                                                              //hag_3=(ha+w.hg)3
      //===============================
       
      //equation selection
      equation
        ma3*hag_3 = ma1*hag_1 + ma2*hag_2;         //From Eq.12.56(c),Pg:497
        //From inspection of Fig. A-9, T3 = 19 deg C.
  end Ex12_14_b;
  //===============================
end Ex12_14;
