/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_2 Page:460
//Title:Converting Mass Fractions to Mole Fractions
//===============================
package Ex12_2
  model Ex12_2_a
  //To find composition in terms of mole fraction
    
      //parameter selection
      parameter Real[3] m(each unit = "-") = {0.10, 0.60, 0.30} "mass fraction of H2,N2,CO2";
      parameter Real[3] M(each unit = "kg/kmol") = {2, 28.01, 44.01} "molecular mass of H2,N2,CO2";
                                                                    /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real[3] n(each unit = "kmol/100 kg") "mole fraction of H2,N2,CO2";
      Real[3] y(each unit = "%") "mole fraction percentage of H2,N2,CO2";
      Real N(unit = "kmol/100 kg") "total amount of moles in the mixture";
      //===============================
      
      //equation selection  
      equation
        for i in 1:3 loop
          n[i] = m[i] / M[i]* 100;
          y[i] = n[i] / N* 100 ;
        end for;
        N = n[1] + n[2] + n[3];
                                  //From Eq.12.1,Eq.12.3 and Eq.12.6, Pg:458
  end Ex12_2_a;
  //===============================

  model Ex12_2_b
  //To find apparent molecular weight of the mixture
  
      //===============================
      extends Ex12_2_a;
      //===============================
      
      //parameter selection
      parameter Real base(unit="kg")=100"base of the solution";
      //===============================
      
      //variable selection
      Real Mw(unit="kg/kmol")"apparent molecular weight of the mixture";
      //===============================
      
      //equation selection
      equation
        Mw=base/N;     //From Eq.12.8, Pg:459
  
  end Ex12_2_b;
  //===============================
end Ex12_2;
