/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_3 Page:467
//Title:Analyzing an Ideal Gas Mixture Undergoing Compression
//===============================
package Ex12_3
  model Ex12_3_a
  //To find the final temperature
  
      //parameter selection
      parameter Real T1(unit = "R") = 540 "initial temperature";
      parameter Real p1(unit = "atm") = 1 "initial pressure";
      parameter Real p2(unit = "atm") = 3 "final pressure";
      parameter Real n(unit = "-") = 1.25 "polytropic index";
      //===============================
      
      //variable selection
      Real T2(unit = "R") "final temperature";
      //===============================
      
      //equation selection
      equation
        T2 / T1 = (p2 / p1) ^ ((n - 1) / n);      //Pressure-Temperature relation of polytropic process

  end Ex12_3_a;
  //===============================

  model Ex12_3_b
  //To find the work
  
      //===============================
      extends Ex12_3_a;
      //===============================
      
      //parameter selection
      parameter Real m1(unit="lb")=0.3"mass of carbon dioxide";
      parameter Real m2(unit="lb")=0.2"mass of nitrogen";
      final constant Real R(final unit = "ft.lbf/lb-mol.R") = 1545.33 "gas constant";
      final constant Real M1(unit="lb/lb-mol")=44.01"molecular mass of CO2";
      final constant Real M2(unit="lb/lb-mol")=28.01"molecular mass of N2";
      //===============================   
      
      //variable selection
      Real W(unit="Btu")"work";
      Real M(unit="lb/lb-mol")"apparent molecular weight of the mixture";
      Real n1(unit="lb-mol")"number of moles of CO2";
      Real n2(unit="lb-mol")"number of moles of N2";
      //===============================
      
      //equation selection
      equation
        n1=m1/M1;
        n2=m2/M2;                                //Number of moles
        M=(m1+m2)/(n1+n2);
        W=(m1+m2)*(R/M)*(T2-T1)/(1-n)*(1/778);   //Work for compression process in terms of temperature
                                                 //Dividing by 778 to convert into Btu
      
  end Ex12_3_b;
  //===============================

  model Ex12_3_c
  //To find heat transfer
  
      //===============================
      extends Ex12_3_a;
      extends Ex12_3_b;
      //===============================
      
      //parameter selection
      parameter Real uT1_1(unit="Btu/lb-mol")=2984"specific internal energy of CO2 at state 1";
                                                                      /*From Table A-23E at 
                                                                      T=540 R for CO2. 
                                                                      Appendix Pg:A-91*/
      parameter Real uT2_1(unit="Btu/lb-mol")=3954"specific internal energy of CO2 at state 2";
                                                                      /*From Table A-23E at 
                                                                      T=679.69 R for CO2. 
                                                                      Appendix Pg:A-91*/
      parameter Real uT1_2(unit="Btu/lb-mol")=2678"specific internal energy of N2 at state 1";
                                                                      /*From Table A-23E at 
                                                                      T=540 R for N2. 
                                                                      Appendix Pg:A-91*/
      parameter Real uT2_2(unit="Btu/lb-mol")=3340"specific internal energy of N2 at state 2";
                                                                      /*From Table A-23E at 
                                                                      T=679.69 R for N2. 
                                                                      Appendix Pg:A-91*/
      //===============================
      
      //variable selection
      Real del_U(unit="Btu")"change in internal energy of the mixture";
      Real Q(unit="Btu")"heat transfer";
      //===============================
      
      //equation selection
      equation
        del_U=n1*(uT2_1-uT1_1)+n2*(uT2_2-uT1_2);     //From Eq.12.30, Pg:465
        Q=del_U+W;                                  //Closed system energy balance
      
  end Ex12_3_c;
  //===============================

  model Ex12_3_d
  //To find change in entropy
  
      //===============================
      extends Ex12_3_a;
      extends Ex12_3_b;
      //===============================
      
      //parameter selection
      parameter Real sT1_1(unit="Btu/lb-mol.R")=51.082"specific entropy of CO2 at state 1";
                                                                      /*From Table A-23E at 
                                                                      T=540 R for CO2. 
                                                                      Appendix Pg:A-91*/
      parameter Real sT2_1(unit="Btu/lb-mol.R")=53.123"specific entropy of CO2 at state 2";
                                                                      /*From Table A-23E at 
                                                                      T=679.69 R for CO2. 
                                                                      Appendix Pg:A-91*/
      parameter Real sT1_2(unit="Btu/lb-mol.R")=45.781"specific entropy of N2 at state 1";
                                                                      /*From Table A-23E at 
                                                                      T=540 R for N2. 
                                                                      Appendix Pg:A-91*/
      parameter Real sT2_2(unit="Btu/lb-mol.R")=47.313"specific entropy of N2 at state 2";
                                                                      /*From Table A-23E at 
                                                                      T=679.69 R for N2. 
                                                                      Appendix Pg:A-91*/
      final constant Real R1(final unit="Btu/lb-mol.R")=1.986"gas constant";
      //===============================
      
      //variable selection
      Real del_S(unit="Btu/R")"change in entropy";
      //===============================
      
      //equation selection
      equation
        del_S=n1*(sT2_1-sT1_1-R1*log(p2/p1))+n2*(sT2_2-sT1_2-R1*log(p2/p1));     //From Eq.12.36, Pg:466
  
  end Ex12_3_d;
  //===============================
end Ex12_3;
