/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_4 Page:468
//Title:Considering an Ideal Gas Mixture Expanding Isentropically Through a Nozzle
//===============================
package Ex12_4
  model Ex12_4_a
  //To find temperature at nozzle exit
  
      //parameter selection
      parameter Real y1(unit = "-") = 0.2 "mole fraction of O2";
      parameter Real y2(unit = "-") = 0.8 "mole fraction of CO2";
      parameter Real p1(unit = "atm") = 5 "pressure at state 1";
      parameter Real p2(unit = "atm") = 1 "pressure at state 2";
      parameter Real sT1_1(unit = "kJ/kmol.K") = 231.358 "specific entropy of O2 at state 1";
                                                                    /*From Table A-23 at 
                                                                    T=700 K for O2. Appendix Pg:A-42*/
      parameter Real sT1_2(unit = "kJ/kmol.K") = 250.663 "specific entropy of CO2 at state 1";
                                                                    /*From Table A-23 at 
                                                                    T=700 K for CO2. Appendix Pg:A-42*/
      parameter Real Ta(unit="K")=510"temperature a";
      parameter Real Tb(unit="K")=520"temperature b";
      parameter Real sTa(unit="kJ.kmol.K")=232.80"entropy of mixture at temperature Ta";
      parameter Real sTb(unit="kJ.kmol.K")=233.62"entropy of mixture at temperature Tb";
                                                                    /*From Ex 12.4, Pg:469*/
      final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
      final constant Real M1(final unit="kg/kmol")=32.00"molecular mass of O2";
      final constant Real M2(final unit="kg/kmol")=44.01"molecular mass of CO2";
      //===============================
      
      //variable selection
      Real sT2(unit = "kJ/kmol.K") "total entropy of the mixture at state 2";
                                                              //sT2= n1.sO2(T2)+n2.sCO2(T2)
      Real T2(unit="K")"temperature at state 2";
      //===============================
      equation
        sT2 = y1 * sT1_1 + y2 * sT1_2 + R * log(p2 / p1);     //From Eq.12.35, Pg:466
        (T2-Ta)/(Tb-Ta)=(sT2-sTa)/(sTb-sTa);                  //Interpolation
  end Ex12_4_a;
  //===============================

  model Ex12_4_b
  //To find entropy change
  
      //===============================
      extends Ex12_4_a;
      //===============================
      
      //parameter selection
      parameter Real sT2_1(unit="kJ/kmol.K")=221.667"specific entropy of O2 at state 2";
                                                                      /*From Table A-23 at 
                                                                      T=517.6 K for O2. Appendix Pg:A-41*/
      parameter Real sT2_2(unit="kJ/kmol.K")=236.365"specific entropy of CO2 at state 2";
                                                                      /*From Table A-23 at 
                                                                      T=517.6 K for CO2. Appendix Pg:A-41*/
      //===============================
      
      //variable selection
      Real del_sO2(unit="kJ/kmol.K")"change in entropy for O2";
      Real del_sCO2(unit="kJ/kmol.K")"change in entropy for CO2";
      //===============================
      
      //equation selection
      equation
        del_sO2=sT2_1-sT1_1-R*log(p2/p1);
        del_sCO2=sT2_2-sT1_2-R*log(p2/p1);    //From Eq.12.35, Pg:466
  
  end Ex12_4_b;
  //===============================

  model Ex12_4_c
  //To find exit velocity
  
      //===============================
      extends Ex12_4_a;
      //===============================
      
      //parameter selection
      parameter Real V1(unit="m/s")=3"inlet velocity";
      parameter Real hT1_1(unit="kJ/kg")=21184"specific enthalpy of O2 at state 1";
                                                                /*From Table A-23 at 
                                                                T=700 K for O2. Appendix Pg:A-42*/
      parameter Real hT2_1(unit="kJ/kg")=15320"specific enthalpy of O2 at state 2";
                                                                /*From Table A-23 at 
                                                                T=517.6 K for CO2. Appendix Pg:A-41*/
      parameter Real hT1_2(unit="kJ/kg")=27125"specific enthalpy of CO2 at state 1";
                                                                /*From Table A-23 at 
                                                                T=700 K for O2. Appendix Pg:A-42*/
      parameter Real hT2_2(unit="kJ/kg")=18468"specific enthalpy of CO2 at state 2";
                                                                /*From Table A-23 at 
                                                                T=517.6 K for O2. Appendix Pg:A-41*/
      //===============================
      
      //variable selection
      Real V2(unit="m/s")"velocity at the exit";
      Real h21(unit="kJ/kg")"specific enthalpy difference";   //h21=h1-h2;
      Real M(unit="kg/kmol")"apparent molecular weight of the mixture";
      //===============================
      
      //equation selection
      equation
        M=y1*M1+y2*M2;
        h21=1/M*(y1*(hT1_1-hT2_1)+y2*(hT1_2-hT2_2));    //From Eq.12.31, Pg:465
        V2=sqrt(V1^2+2*h21*10^3);                       //Reduced steady state mass and energy balance
      
  end Ex12_4_c;
  //===============================
end Ex12_4;
