/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_6 Page:472
//Title:Analyzing Adiabatic Mixing of Two Streams
//===============================
package Ex12_6
  model Ex12_6_a
  //To find mass flow rates
    
      //parameter selection
      parameter Real p1(unit = "bar") = 1 "pressure of air stream";
      parameter Real T1(unit = "C") = 32 "temperature of air stream";
      parameter Real p2(unit = "bar") = 1 "pressure of oxygen stream";
      parameter Real T2(unit = "C") = 127 "temperature of oxygen stream";
      parameter Real p3(unit = "bar") = 1 "pressure of mixed stream";
      parameter Real T3(unit = "C") = 47 "temperature of mixed stream";
      parameter Real AV1(unit = "m3/min") = 100 "volumetric flow rate of oxygen stream";
      parameter Real haT3(unit = "kJ/kg") = 320.29 "specific enthalpy of air at stream 3";
                                                                /*From Table A-22 at T=320 K.
                                                                Appendix Pg:A-39*/
      parameter Real haT1(unit = "kJ/kg") = 305.22 "specific enthalpy of air at stream 1";
                                                                /*From Table A-22 at T=305 K.
                                                                Appendix Pg:A-39*/
      parameter Real hoT2(unit = "kJ/kmol") = 11711 "specific enthalpy of oxygen at stream 2";
                                                                /*From Table A-22 at T=400 K 
                                                                for oxygen.Appendix Pg:A-41*/
      parameter Real hoT3(unit = "kJ/kmol") = 9325 "specific enthalpy of oxygen at stream 3";
                                                                /*From Table A-23 at T=320 K 
                                                                for oxygen.Appendix Pg:A-41*/
      final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
      final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
      final constant Real Mo(final unit = "kg/kmol") = 32.00 "molecular mass of oxygen";
                                                                /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real va1(unit = "m3/kg") "specific volume of air";
      Real ma1(unit = "kg/min") "mass flow rate of dry air";
      Real mo(unit = "kg/min") "mass flow rate of oxygen";
      //===============================
      
      //equation selection
      equation
      ma1 = AV1 / va1;
      va1 = R / Ma * (T1 + 273.15) / (p1 * 10 ^ 5);               //Ideal gas equation of state
                                                                  //Multiplying by 10^5 to convert into Pa
                                                                  //Adding 273.15 to convert into Kelvin scale
      mo = ma1 * (haT3 - haT1) / (1 / Mo * (hoT2 - hoT3));        //Reduced energy rate balance
  end Ex12_6_a;
  //===============================

  model Ex12_6_b
  //To find the mole frations
  
      //===============================
      extends Ex12_6_a;
      //===============================
      
      //variable selection
      Real na(unit="kmol/min")"molar flow rate of air";
      Real no(unit="kmol/min")"molar flow rate of oxygen";
      Real ya(unit="-")"mole fraction of air";
      Real yo(unit="-")"mole fraction of oxygen";
      //===============================
      
      //equation selection
      equation
        na=ma1/Ma;
        no=mo/Mo;          //Molar flow rate
        ya=na/(na+no);
        yo=no/(na+no);     //Mole fraction
      //===============================
  end Ex12_6_b;

  model Ex12_6_c
  //To find time rate of entropy production
  
      //===============================
      extends Ex12_6_a;
      extends Ex12_6_b;
      //===============================
      
      //parameter selection
      parameter Real saT1(unit="kJ/kg.K")=1.71865"specific entropy of air at stream 1";
                                                                  /*From Table A-22 at T=320 K.
                                                                  Appendix Pg:A-39*/
      parameter Real saT3(unit="kJ/kg.K")=1.7669"specific entropy of air at stream 3";
                                                                  /*From Table A-22 at T=305 K.
                                                                  Appendix Pg:A-39*/
      parameter Real soT2(unit="kJ/kmol.K")=213.765"specific entropy of oxygen at stream 2";
                                                                  /*From Table A-22 at T=400 K 
                                                                  for oxygen.Appendix Pg:A-41*/
      parameter Real soT3(unit="kJ/kmol.K")=207.112"specific entropy of oxygen at stream 3";
                                                                  /*From Table A-23 at T=320 K 
                                                                  for oxygen.Appendix Pg:A-41*/
      final constant Real R1(final unit = "kJ/kmol.K") = 8.314 "gas constant";
      //===============================
      
      //variable selection
      Real sigma(unit="kJ/K.min")"entropy production rate";
      //===============================
      
      //equation selection
      equation
        sigma=ma1*(saT3-saT1-R1/Ma*log(ya))+mo/Mo*(soT3-soT2-R1*log(yo));    //Reduced entropy rate balance
      
  end Ex12_6_c;
  //===============================
end Ex12_6;
