/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion 
//Example 13_12 Page:543
//Title:Evaluating the Chemical Exergy of Liquid Octane
//===============================
package Ex13_12
  model Ex13_12_a
  //To find chemical exergy from Eq.13.36
  
    //parameter selection
    parameter Real a(unit = "-") = 8 "number of carbon atoms";
    parameter Real b(unit = "-") = 18 "number of hydrogen atoms";
    parameter Real c(unit = "-") = 0 "number of oxygen atoms";
    parameter Real c_N2(unit = "%") = 75.67 "composition of N2";
    parameter Real c_O2(unit = "%") = 20.35 "composition of O2";
    parameter Real c_H2O(unit = "%") = 3.12 "composition of H2O";
    parameter Real c_CO2(unit = "%") = 0.03 "composition of CO2";
    parameter Real c_other(unit = "%") = 0.83 "composition of others";
    parameter Real gC8H18(unit = "kJ/kmol") = 6610 "Gibbs function of formation of C8H18";
                                                              /*From Table A-25 for C8H18. 
                                                              Appendix Pg:A-46*/
    parameter Real gO2(unit = "kJ/kmol") = 0 "Gibbs function of formation of O2";
                                                              /*From Table A-25 for O2. 
                                                              Appendix Pg:A-46*/
    parameter Real gCO2(unit = "kJ/kmol") = -394380 "Gibbs function of formation of CO2";
                                                              /*From Table A-25 for CO2. 
                                                              Appendix Pg:A-46*/
    parameter Real gH2O(unit = "kJ/kmol") = -228590 "Gibbs function of formation of H2O";
                                                              /*From Table A-25 for H2O. 
                                                              Appendix Pg:A-46*/
    parameter Real M(unit = "kg/kmol") = 114.22 "molecular mass of octane";
    parameter Real nC8H18(unit = "kmol") = 1 "moles of C8H18";
    parameter Real nO2(unit = "kmol") = 12.5 "moles of O2";
    parameter Real nCO2(unit = "kmol") = 8 "moles of CO2";
    parameter Real nH2O(unit = "kmol") = 9 "moles of hydrogen";
    parameter Real T0(unit = "C") = 25 "temperature of octane";
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real e_ch_a(unit = "kJ/kmol") "molar chemical exergy";
    Real e_chm_a(unit = "kJ/kg") "chemical exergy on mass basis";
    Real yO2(unit = "-") "mole fraction of O2";
    Real yCO2(unit = "-") "mole fraction of CO2";
    Real yH2O(unit = "-") "mole fraction of H2O";
    //===============================
    equation
      yO2 = c_O2 * 0.01;
      yCO2 = c_CO2 * 0.01;
      yH2O = c_H2O * 0.01;              //Mole fraction
      e_ch_a = gC8H18 + nO2 * gO2 - nCO2 * gCO2 - nH2O * gH2O + R * (T0 + 273.15) * log(yO2 ^ nO2 / (yCO2 ^ nCO2 * yH2O ^ nH2O));
                                        //From Eq.13.36, Pg:538
      e_chm_a = e_ch_a / M;
  end Ex13_12_a;
  //===============================

  model Ex13_12_b
  //To find chemical exergy from Eq.13.44b
  
    //===============================
    extends Ex13_12_a;
    //===============================
    
    //parameter selection
    parameter Real gH2Ol(unit = "kJ/kmol") = -237180 "Gibbs function of formation of H2O(l)";       
                                                                    /*From Table A-25 for H2O(l). 
                                                                    Appendix Pg:A-46*/
    parameter Real e_chCO2(unit = "kJ/kmol") = 19870 "molar chemical exergy of CO2";               
                                                                    /*From Table A-26 Model-II for CO2. 
                                                                    Appendix Pg:A-47*/
    parameter Real e_chH2O(unit = "kJ/kmol") = 900 "molar chemical exergy of H2O";              
                                                                    /*From Table A-26 Model-II for H2O. 
                                                                    Appendix Pg:A-47*/
    parameter Real e_chO2(unit = "kJ/kmol") = 3970 "molar chemical exergy of O2";              
                                                                    /*From Table A-26 Model-II for O2. 
                                                                    Appendix Pg:A-47*/
    //===============================
    
    //variable selection
    Real e_ch_b(unit = "kJ/kmol") "molar chemical exergy";
    Real e_chm_b(unit = "kJ/kg") "chemical exergy on mass basis";
    //===============================
    
    //equation selection
    equation
      e_ch_b = gC8H18 + nO2 * gO2 - nCO2 * gCO2 - nH2O * gH2Ol + nCO2 * e_chCO2 + nH2O * e_chH2O - nO2 * e_chO2;
                                              //From Eq.13.44(b), Pg:543
      e_chm_b = e_ch_b / M;
  end Ex13_12_b;
  //===============================
end Ex13_12;
