/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_13 Page:545
//Title:Evaluating the Total Flow Exergy of Process Steam
//===============================
model Ex13_13

  //parameter selection
  parameter Real m(unit="kg/s")=14"mass flow rate of vapour";
  parameter Real T0(unit="K")=298.15"dead state temperature";
  parameter Real h0(unit="kJ/kg")=104.9"specific enthalpy at state 0";
  parameter Real s0(unit="kJ/kg.K")=0.3674"specific entropy at state 0";
                                                                    /*From Table A-2 at T=25 C 
                                                                    for saturated liquid. 
                                                                    Appendix Pg:A-3*/
  parameter Real h9(unit="kJ/kg")=2799.5"specific enthalpy at state 9";
  parameter Real s9(unit="kJ/kg.K")=6.3409"specific entropy at state 9";          
                                                                    /*From Table A-4 at p=20 bar 
                                                                    for saturated vapour. 
                                                                    Appendix Pg:A-8*/
  parameter Real e_ch(unit="kJ/kmol")=900 "molar chemical exergy of H2O";              
                                                                    /*From Table A-26 Model-II for H2O. 
                                                                    Appendix Pg:A-47*/
  
  final constant Real M(unit="kg/kmol")=18.02"molecular mass of water";
  //===============================
  
  //variable selection
  Real ef(unit="kJ/kg")"total flow exergy";
  Real E9(unit="MW")"total flow exergy rate";
  //===============================
  
  //equation selection
  equation
    ef=(h9-h0)-T0*(s9-s0)+e_ch/M;     //From Eq.13.47, Pg:545
    E9=m*(ef)*(1/10^3);               //Dividing by MW to convert into MW
end Ex13_13;
//===============================
