/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_15 Page:548
//Title:Evaluating the Total Flow Exergy of Combustion Products
//===============================
model Ex13_15

  //parameter selection
  parameter Real T0(unit="K")=298.15"temperature of the dead state";
  parameter Real p0(unit="atm")=1"pressure of the dead state";
  parameter Real m(unit="kg/s")=92.92"mass flow rate";
  parameter Real M(unit="kg/kmol")=28.25"molecular weight of mixture";
  parameter Real [5]c(each unit = "%") = {75.07,13.72,3.14,2.97,5.10} "composition"; 
                                                                //N2,O2,CO2,H2O(g),H2O(l)
  parameter Real[5] s(each unit="kJ/kmol.K")={191.502,205.033,213.685,188.720,69.95}"specific entropy";                                         
                                                                //N2,O2,CO2,H2O(g),H2O(l)
                                                                /*From Table A-23 at T=298 K for
                                                                N2,O2,CO2,H2O(g),H2O(l). 
                                                                Appendix Pg:A-41*/
  parameter Real [5]h(each unit="kJ/kmol")={0,0,-393520,-241820,-285830}"specific enthalpy of formation";
                                                                //N2,O2,CO2,H2O(g),H2O(l) 
                                                                /*From Table A-25 for N2,O2,CO2,H2O(g),H2O(l). 
                                                                Appendix Pg:A-46*/
  parameter Real[5] e_chi(each unit="kJ/kmol")={720,3970,19870,9500,900}"molar chemical exergy";
                                                                //N2,O2,CO2,H2O(g),H2O(l)
                                                                /*From Table A-26 Model II for 
                                                                N2,O2,CO2,H2O(g),H2O(l). Appendix Pg:A-47*/
  parameter Real h4(unit="kJ/kg")=322"specific enthalpy at state 4";
  parameter Real s4(unit="kJ/kg.K")=8.32"specific entropy at state 4";
                                                               
  final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
  //===============================
  
  //variable selection
  Real [4]y(each unit="-")"mole fraction";
  Real [4]s_(each unit="kJ/kmol.K")"specific entropy";
  Real [4]e_chgasi(each unit="kJ/kmol")"chemical exergy values";
                                                //N2,O2,CO2,H2O(g),H2O(l) 
  Real h0(unit="kJ/kmol")"mixture enthalpy";
  Real h0m(unit="kJ/kg")"mixture enthalpy in mass basis";
  Real s0(unit="kJ/kmol.K")"mixture entropy";
  Real s0m(unit="kJ/kg.K")"mixture entropy in mass basis";
  Real e_chgas(unit="kJ/kmol")"chemical exergy values for gas phase";
  Real e_ch(unit="kJ/kmol")"total chemical exergy";
  Real e_chm(unit="kJ/kg")"total chemical exergy in mass basis";
  Real ef(unit="kJ/kg")"total flow exergy";
  Real E4(unit="MW")"total flow exergy on time-rate basis";
  Real c_tot(unit="kmol")"total combuston products in gas phase";
  //===============================
  
  //equation selection
  equation
    c_tot=(c[1]+c[2]+c[3]+c[4])*0.01;
    
    for i in 1:4 loop
     y[i]=c[i]/c_tot*0.01;                                            //Mole fraction
                                                                      //Multiplying by 0.01 due to percentage
    end for;
    
    h0=(c[1]*h[1]+c[2]*h[2]+c[3]*h[3]+c[4]*h[4]+c[5]*h[5])*0.01;      //From Eq.13.9, Pg:513
    
    for i in 1:4 loop
     s_[i]=s[i]-R*log(y[i]);                                          //From Eq.13.23, Pg:531
     e_chgasi[i]=y[i]*e_chi[i]+R*T0*y[i]*log(y[i]);                   //From Eq.13.41(b), Pg:540
    end for;
    
    s0=(c[1]*s_[1]+c[2]*s_[2]+c[3]*s_[3]+c[4]*s_[4]+c[5]*s[5])*0.01;
    e_chgas=e_chgasi[1]+e_chgasi[2]+e_chgasi[3]+e_chgasi[4];
    e_ch=e_chgas*(c_tot)+c[5]*0.01*e_chi[5];
    e_chm=e_ch/M;
    h0m=h0/M;
    s0m=s0/M;
    ef=(h4-h0m)-T0*(s4-s0m)+e_chm;                                     //From Eq.13.47, Pg:545
    E4=m*ef*(1/10^3);                                                  //Total flow exergy 
                                                                       //Dividing by 10^3 to convert into MW

end Ex13_15;
//===============================
