/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_2 Page:509
//Title:Using a Dry Product Analysis for Combustion of Methane
//===============================
package Ex13_2
  model Ex13_2_a
  //To find air-fuel ratio
  
    //parameter selection
    parameter Real n_O2(unit = "mole") = 1 "moles of oxygen in air";
    parameter Real n_N2(unit = "mole") = 3.76 "moles of nitrogen in air";
    parameter Real n_CH4(unit = "kmol") = 1 "moles of methane";
    parameter Real CO2_p(unit = "%") = 9.7 "percent of CO2 in product";
    parameter Real CO_p(unit = "%") = 0.5 "percent of CO in product";
    parameter Real O2_p(unit = "%") = 2.95 "percent of O2 in product";
    parameter Real N2_p(unit = "%") = 86.85 "percent of N2 in product";
    final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
    final constant Real MCH4(final unit = "kg/kmol") = 16.04 "molecular mass of methane";
    //===============================
    
    //variable selection
    Real a(unit = "-") "stoichiometric coefficient for C in chemical equation";
    Real b(unit = "-") "stoichiometric coefficient for O in chemical equation";
    Real c(unit = "-") "stoichiometric coefficient for H in chemical equation";
    Real AF(unit = "kmol(air)/kmol(fuel)") "air-fuel ratio on molar basis";
    Real AFm(unit = "kg(air)/kg(fuel)") "air-fuel ratio on mass basis";
    //===============================
    
    //equation selection
    equation
      CO2_p + CO_p = a;
      2 * c = 4 * a;
      CO2_p * 2 + CO_p + 2 * O2_p + c = 2 * b; 
                                    
      AF = (b + b * n_N2) / a;      //Air-fuel ratio
      AFm = AF * Ma / MCH4;         //From Eq.13.2, Pg:506
  end Ex13_2_a;

  model Ex13_2_b
  //To find percent theoretical air
  
    //===============================
    extends Ex13_2_a;
    //===============================
  
    //variable selection
    Real AFtheo(unit = "lbmol(air)/lbmol(fuel)") "theoretical air–fuel ratio on a molar basis";
    Real theo_air(unit = "%") "percent theoretical air";
    //===============================
  
    //equation selection
    equation
      AFtheo = 2 * (n_O2 + n_N2) / n_CH4;     //Air-fuel ratio
      theo_air = AF / AFtheo * 100;           //Percent theoretical air
  end Ex13_2_b;

  //===============================

  model Ex13_2_c
  //To find the dew point point temperature
  
    //===============================
    extends Ex13_2_a;
    //===============================
    
    //parameter selection
    parameter Real p(unit = "atm") = 1 "total pressure";
    parameter Real base(unit = "lbmol") = 100 "basis of solution";
    parameter Real Ta(unit="F")=130"temperature a";
    parameter Real Tb(unit="F")=140"temperature b";
    parameter Real pva(unit="lbf/in2")=2.225"pressure a";
    parameter Real pvb(unit="lbf/in2")=2.892"pressure b";
                                        /*From Table A-2E for pv=2.484 lbf/in^2. 
                                        Appendix Pg:A-51*/
    
    //===============================
    
    //variable selection
    Real yv(unit = "-") "mole fraction of water vapour in product";
    Real pv(unit = "atm") "partial pressure of water vapour";
    Real T(unit="F")"dew point temperature";
    //===============================
    
    //equation selection
    equation
      yv = c / (base + c);                 //Mole fraction
      pv = yv * p * 14.696;                //Partial pressure
                                           //Multiplying by 14.6959 to convert into lbf/in^2
      (T-Ta)/(Tb-Ta)=(pv-pva)/(pvb-pva);   //Interpolation
  
  end Ex13_2_c;
  //===============================

  model Ex13_2_d
  //To find the amount of water vapour
  
    //===============================
    extends Ex13_2_c;
    //===============================
    
    //parameter selection
    parameter Real pwv(unit = "lbf/in^2") = 0.6988 "saturation  pressure of water vapour";
    parameter Real n_p(unit = "lbmol") = 9.8 "amount of dry products";
    //===============================
    
    //variable selection
    Real n(unit = "lbmol") "amount of water vapour present";
    //===============================
    
    //equation selection
    equation
     pwv = n / (n + n_p) * p * 14.6959;            //Partial pressure
                                                   //Multiplying by 14.6959 to convert into lbf/in^2
  end Ex13_2_d;
  //===============================
end Ex13_2;
