/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_5 Page:517
//Title:Analyzing a Gas Turbine Fueled with Methane
//===============================
model Ex13_5

    //parameter selection
    parameter Real Mf(unit="kg/kmol")=16.04"molecular weight of fuel";     
                                                                /*From Table A-1 for methane. 
                                                                Appendix Pg:A-2*/
    parameter Real mf(unit="kg/min")=20"mass flow rate of fuel";
    parameter Real hR(unit="kJ/kmol(fuel)")=-74850"specific enthalpy of formation for C8H18";    
                                                                /*From Table A-25 for CH4. 
                                                                Appendix Pg:A-46*/
    parameter Real hCO2(unit="kJ/kmol")=-393520"specific enthalpy of formation for CO2";         
                                                                /*From Table A-25 for CO2. 
                                                                Appendix Pg:A-46*/
    parameter Real hCO2_1(unit="kJ/kmol")=9364"specific enthalpy of CO2 at state 1";     
                                                                /*From table A-23 at T=298 K. 
                                                                Appendix Pg:A-41*/
    parameter Real hCO2_2(unit="kJ/kmol")=28622"specific enthalpy of CO2 at state 2";       
                                                                /*From table A-23 at T=730 K. 
                                                                Appendix Pg:A-42*/
    parameter Real hH2O(unit="kJ/kmol")=-241820"specific enthalpy of formation for H2O";       
                                                                /*From Table A-25 for H2O. 
                                                                Appendix Pg:A-46*/
    parameter Real hH2O_1(unit="kJ/kmol")=9904"specific enthalpy of H2O at state 1";
                                                                /*From table A-23 at T=298 K. 
                                                                Appendix Pg:A-41*/
    parameter Real hH2O_2(unit="kJ/kmol")=25218"specific enthalpy of H2O at state 2";
                                                                /*From table A-23 at T=730 K. 
                                                                Appendix Pg:A-42*/
    parameter Real hO2_1(unit="kJ/kmol")=8682"specific enthalpy of O2 at state 1";
                                                                /*From table A-23 at T=298 K. 
                                                                Appendix Pg:A-41*/
    parameter Real hO2_2(unit="kJ/kmol")=22177"specific enthalpy of O2 at state 2";
                                                                /*From table A-23 at T=730 K. 
                                                                Appendix Pg:A-42*/
    parameter Real hN2_1(unit="kJ/kmol")=8669"specific enthalpy of CO2 at state 1";    
                                                                /*From table A-23 at T=298 K. 
                                                                Appendix Pg:A-41*/
    parameter Real hN2_2(unit="kJ/kmol")=21529"specific enthalpy of CO2 at state 2";
                                                                /*From table A-23 at T=730 K. 
                                                                Appendix Pg:A-42*/
    //===============================
    
    //variable selection
    Real a(unit = "-") "stoichiometric coefficient for C in chemical equation";
    Real b(unit = "-") "stoichiometric coefficient for H in chemical equation";
    Real c(unit = "-") "stoichiometric coefficient for O in chemical equation";
    Real d(unit = "-") "stoichiometric coefficient for N in chemical equation";
    Real hP(unit="kJ/kmol(fuel)")"net specific enthalpy for formation and state 1 and 2";
    Real Qcv(unit="MW")"heat transfer rate";
    Real Wcv(unit="MW")"power output";
    Real nF(unit="kmol(fuel)/s")"molar flow rate of fuel";
    //===============================
    
    //equation selection
    equation
      1=a;
      4=2*b;
      4.0*2*2=2*a+b+2*c;
      4.0*2*3.76*2=2*d;                                               //Mass balance for equation
      Qcv=-0.03*Wcv;
      hP=a*(hCO2+hCO2_2-hCO2_1)+b*(hH2O+hH2O_2-hH2O_1)+c*(hO2_2-hO2_1)+d*(hN2_2-hN2_1);  
                                                                      //From Eq.13.9, Pg:513
      nF=mf/Mf*(1/60);                                                //Molar flow rate
                                                                      //Dividing by 60 to convert into per s
      Qcv-Wcv=nF*(hP-hR)*(1/10^3);                                    //Reduced energy rate balance
                                                                      //Dividing by 10^3 to convert into MW
                                                                          
end Ex13_5;
//===============================
