/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_7 Page:521
//Title:Calculating Enthalpy of Combustion of Methane
//===============================
package Ex13_7
  model Ex13_7_a
  //To find enthalpy of combustion with liquid water in products
  
    //parameter selection  
    parameter Real hCH4(unit = "kJ/kmol(fuel)") = -74850 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for CH4. 
                                                                      Appendix Pg:A-46*/
    parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
    parameter Real hH2O(unit = "kJ/kmol") = -285830 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
    parameter Real Mf(unit="kg/kmol")=16.04"molecular weight of fuel";     
                                                                      /*From Table A-1 for methane. 
                                                                      Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real hRP(unit="kJ/kmol(fuel)")"enthalpy of formation values";
    Real hRPm(unit="kJ/kg(fuel)")"enthalpy of formation values on unit mass of fuel basis";
    //===============================
    
    //equation selection
    equation
      hRP=hCO2+2*hH2O-hCH4;       //Enthalpy of combustion
      hRPm=hRP/Mf;
  end Ex13_7_a;
  //===============================

  model Ex13_7_b
  //To find enthalpy of combustion with water vapour in products
  
    //parameter selection  
    parameter Real hCH4(unit = "kJ/kmol(fuel)") = -74850 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for CH4. 
                                                                      Appendix Pg:A-46*/                           
    parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
    parameter Real hH2O(unit = "kJ/kmol") = -241820 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
    parameter Real Mf(unit="kg/kmol")=16.04"molecular weight of fuel";     
                                                                      /*From Table A-1 for methane. 
                                                                      Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real hRP(unit="kJ/kmol(fuel)")"enthalpy of formation values";
    Real hRPm(unit="kJ/kg(fuel)")"enthalpy of formation values on unit mass of fuel basis";
    //===============================
    
    //equation selection
    equation
      hRP=hCO2+2*hH2O-hCH4;       //Enthalpy of combustion
      hRPm=hRP/Mf;
  end Ex13_7_b;
  //===============================

  model Ex13_7_c
  //To find enthalpy of combustion with water vapour in products at 1000 K
  
    //parameter selection
    parameter Real T1(unit="K")=298"initial temperature";
    parameter Real T2(unit="K")=1000"final temperature";
    parameter Real hCH4(unit = "kJ/kmol(fuel)") = -74850 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for CH4. 
                                                                      Appendix Pg:A-46*/                                                            
    parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
    parameter Real hH2O(unit = "kJ/kmol") = -241820 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
    parameter Real hCO2_1(unit="kJ/kmol")=9364"specific enthalpy of CO2 at state 1";     
                                                                      /*From table A-23 for CO2 at T=298 K. 
                                                                      Appendix Pg:A-41*/
    parameter Real hCO2_2(unit="kJ/kmol")=42769"specific enthalpy of CO2 at state 2";       
                                                                      /*From table A-23 for CO2 at T=1000 K. 
                                                                      Appendix Pg:A-43*/
    parameter Real hH2O_1(unit="kJ/kmol")=9904"specific enthalpy of H2O at state 1";
                                                                      /*From table A-23 for H2O at T=298 K. 
                                                                      Appendix Pg:A-41*/
    parameter Real hH2O_2(unit="kJ/kmol")=35882"specific enthalpy of H2O at state 2";
                                                                      /*From table A-23 for H2O at T=1000 K. 
                                                                      Appendix Pg:A-43*/
    parameter Real hO2_1(unit="kJ/kmol")=8682"specific enthalpy of O2 at state 1";
                                                                      /*From table A-23 for O2 at T=298 K. 
                                                                      Appendix Pg:A-41*/
    parameter Real hO2_2(unit="kJ/kmol")=31389"specific enthalpy of O2 at state 2";
                                                                      /*From table A-23 for O2 at T=1000 K. 
                                                                      Appendix Pg:A-43*/
    parameter Real Mf(unit="kg/kmol")=16.04"molecular weight of fuel";     
                                                                      /*From Table A-1 for methane. 
                                                                      Appendix Pg:A-2*/
  
    parameter Real a(unit="kJ/kmol.K")=3.826"constant pressure specific heat capacity coefficient";
    parameter Real b(unit="kJ/kmol.K2")=-3.979e-3"constant pressure specific heat capacity coefficient";
    parameter Real c(unit="kJ/kmol.K3")=24.588e-6"constant pressure specific heat capacity coefficient";
    parameter Real d(unit="kJ/kmol.K4")=-22.733e-9"constant pressure specific heat capacity coefficient";
    parameter Real e(unit="kJ/kmol.K5")=6.963e-12"constant pressure specific heat capacity coefficient";     
                                                                      /*From Table A-21 for CH4. 
                                                                      Appendix Pg:A-38*/
    final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
    //===============================
    
    //variable selection
    Real hRP(unit="kJ/kmol(fuel)")"enthalpy of formation values";
    Real hRPm(unit="kJ/kg(fuel)")"enthalpy of formation values on unit mass of fuel basis";
    Real del_hO2(unit="kJ/kmol")"change in specific enthalpy of O2";
    Real del_hH2O(unit="kJ/kmol")"change in specific enthalpy of H2O";
    Real del_hCO2(unit="kJ/kmol")"change in specific enthalpy of CO2";
    Real del_hCH4(unit="kJ/kmol")"change in specific enthalpy of CH4";
    Real hRPc(unit="kJ/kmol")"enthalpy of formation values at state 2";
    //===============================
    
    //equation selection
    equation
      del_hO2=hO2_2-hO2_1;
      del_hH2O=hH2O_2-hH2O_1;
      del_hCO2=hCO2_2-hCO2_1;                             //Change in enthalpy
      del_hCH4=R*(a*(T2-T1)+b/2*(T2^2-T1^2)+c/3*(T2^3-T1^3)+d/4*(T2^4-T1^4)+e/5*(T2^5-T1^5));     
                                                          //Change in enthalpy in terms of cp coefficients
      hRP=hCO2+2*hH2O-hCH4;
      hRPc=hRP+del_hCO2+2*del_hH2O-del_hCH4-2*del_hO2;    //Enthalpy of combustion
      hRPm=hRPc/Mf;

  end Ex13_7_c;
  //===============================
end Ex13_7;
