/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_9 Page:532
//Title:Evaluating Entropy Production for a Reactor Fueled by Liquid Octane
//===============================
package Ex13_9
  model Ex13_9_a
  //To find rate of entropy production with theoretical amount of air
    
    //parameter selection
    parameter Real yO2_1(unit = "-") = 0.21 "mole fraction of O2 in air";
    parameter Real yN2_1(unit = "-") = 0.79 "mole fraction of N2 in air";
    parameter Real nCO2(unit = "kmol") = 8 "moles of CO2 at exit";
    parameter Real nH2O(unit = "kmol") = 9 "moles of H2O at exit";
    parameter Real nO2_1(unit = "kmol") = 12.5 "moles of O2 at inlet";
    parameter Real nN2_1(unit = "kmol") = 47 "moles of N2 at inlet";
    parameter Real nN2_2(unit = "kmol") = 47 "moles of N2 at exit";
    parameter Real sO2_T1(unit = "kJ/kmol.K") = 205.03 "absolute entropy of O2 at inlet";
    parameter Real sN2_T1(unit = "kJ/kmol.K") = 191.5 "absolute entropy of N2 at inlet";
                                                              /*From Table A-23 at T=298 K. 
                                                              Appendix Pg:A-41*/
    parameter Real sCO2_T2(unit = "kJ/kmol.K") = 320.173 "absolute entropy of CO2 at exit";
    parameter Real sH2O_T2(unit = "kJ/kmol.K") = 273.986 "absolute entropy of H2O at exit";
    parameter Real sN2_T2(unit = "kJ/kmol.K") = 258.503 "absolute entropy of N2 at exit";
                                                              /*From Table A-23 at T=2395 K. 
                                                              Appendix Pg:A-44*/
    parameter Real sF(unit = "kJ/kmol.K") = 360.79 "absolute entropy of liquid octane";
                                                              /*From Table A-25 for octane. 
                                                              Appendix Pg:A-46*/
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real sigmacv_nF(unit = "kJ/kmol(octane).K") "rate of entropy production per kmol of fuel";
    Real sO2(unit = "kJ/kmol.K") "specific entropy of O2 in air";
    Real sN2(unit = "kJ/kmol.K") "specific entropy of N2 in air";
    Real sCO2(unit = "kJ/kmol.K") "specific entropy of CO2 at exit";
    Real sH2O(unit = "kJ/kmol.K") "specific entropy of H2O at exit";
    Real sN2_2(unit = "kJ/kmol.K") "specific entropy of N2 at exit";
    Real yCO2(unit = "-") "mole fraction of CO2 at exit";
    Real yH2O(unit = "-") "mole fraction of H2O at exit";
    Real yN2_2(unit = "-") "mole fraction of N2 at exit";
    //===============================
    
    //equation selection
    equation
      sigmacv_nF = nCO2 * sCO2 + nH2O * sH2O + nN2_2 * sN2_2 - sF - (nO2_1 * sO2 + nN2_1 * sN2);      
                                                     //Entropy rate balance
      yCO2 = nCO2 / (nCO2 + nH2O + nN2_2);
      yH2O = nH2O / (nCO2 + nH2O + nN2_2);
      yN2_2 = nN2_2 / (nCO2 + nH2O + nN2_2);         //Mole fraction
      sO2 = sO2_T1 - R * log(yO2_1);
      sN2 = sN2_T1 - R * log(yN2_1);
      sCO2 = sCO2_T2 - R * log(yCO2);
      sH2O = sH2O_T2 - R * log(yH2O);
      sN2_2 = sN2_T2 - R * log(yN2_2);               //From Eq.13.23, Pg:531
  end Ex13_9_a;
  //===============================

  model Ex13_9_b
  //To find rate of entropy production with 400% excess of air
  
    //parameter selection
    parameter Real yO2(unit = "-") = 0.21 "mole fraction of O2 in air";
    parameter Real yN2_1(unit = "-") = 0.79 "mole fraction of N2 in air";
    parameter Real nCO2(unit = "kmol") = 8 "moles of CO2 at exit";
    parameter Real nH2O(unit = "kmol") = 9 "moles of H2O at exit";
    parameter Real nO2_1(unit = "kmol") = 50 "moles of O2 at inlet";
    parameter Real nN2_1(unit = "kmol") = 188 "moles of N2 at inlet";
    parameter Real nO2_2(unit = "kmol") = 37.5 "moles of O2 at exit";
    parameter Real nN2_2(unit = "kmol") = 188 "moles of N2 at exit";
    parameter Real sO2_T1(unit = "kJ/kmol.K") = 205.03 "absolute entropy of O2 at inlet";
    parameter Real sN2_T1(unit = "kJ/kmol.K") = 191.5 "absolute entropy of N2 at inlet";
                                                              /*From Table A-23 at T=298 K. 
                                                              Appendix Pg:A-41*/
    parameter Real sCO2_T2(unit = "kJ/kmol.K") = 267.12 "absolute entropy of CO2 at exit";
    parameter Real sH2O_T2(unit = "kJ/kmol.K") = 231.01 "absolute entropy of H2O at exit";
    parameter Real sO2_T2(unit = "kJ/kmol.K") = 242.12 "absolute entropy of O2 at inlet";
    parameter Real sN2_T2(unit = "kJ/kmol.K") = 226.795 "absolute entropy of N2 at exit";
                                                              /*From Table A-23 at T=962 K. 
                                                              Appendix Pg:A-44*/
    parameter Real sF(unit = "kJ/kmol.K") = 360.79 "absolute entropy of liquid octane";
                                                              /*From Table A-25 for octane. 
                                                              Appendix Pg:A-46*/
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real sigmacv_nF(unit = "kJ/kmol(octane).K") "rate of entropy production per kmol of fuel";
    Real sO2(unit = "kJ/kmol.K") "specific entropy of O2 in air";
    Real sN2(unit = "kJ/kmol.K") "specific entropy of N2 in air";
    Real sCO2(unit = "kJ/kmol.K") "specific entropy of CO2 at exit";
    Real sH2O(unit = "kJ/kmol.K") "specific entropy of H2O at exit";
    Real sO2_2(unit = "kJ/kmol.K") "specific entropy of O2 at exit";
    Real sN2_2(unit = "kJ/kmol.K") "specific entropy of N2 at exit";
    Real yCO2(unit = "-") "mole fraction of CO2 at exit";
    Real yH2O(unit = "-") "mole fraction of H2O at exit";
    Real yO2_2(unit = "-") "mole fraction of O2 at exit";
    Real yN2_2(unit = "-") "mole fraction of N2 at exit";
    //===============================
    
    //equation selection
    equation
      sigmacv_nF = nCO2 * sCO2 + nH2O * sH2O + nO2_2*sO2_2 + nN2_2 * sN2_2 - sF - (nO2_1 * sO2 + nN2_1 * sN2);                                                              
                                                              //Entropy rate balance
      yCO2 = nCO2 / (nCO2 + nH2O + nO2_2 + nN2_2);
      yH2O = nH2O / (nCO2 + nH2O + nO2_2 + nN2_2);
      yO2_2 = nO2_2 / (nCO2 + nH2O + nO2_2 + nN2_2);
      yN2_2 = nN2_2 / (nCO2 + nH2O + nO2_2 + nN2_2);          //Mole fraction
      sO2 = sO2_T1 - R * log(yO2);
      sO2_2 = sO2_T2 - R * log(yO2_2);
      sN2 = sN2_T1 - R * log(yN2_1);
      sCO2 = sCO2_T2 - R * log(yCO2);
      sH2O = sH2O_T2 - R * log(yH2O);
      sN2_2 = sN2_T2 - R * log(yN2_2);                        //From Eq.13.23, Pg:531

  end Ex13_9_b;
  //===============================
end Ex13_9;
