/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_1 Page:564
//Title:Evaluating the Equilibrium Constant at a Specified Temperature
//===============================
package Ex14_1
  model Ex14_1_a
  //To find equilibrium constant at 298 K
  
    //parameter selection
    parameter Real T(unit = "K") = 298 "reaction temperature";
    parameter Real hCO2f(unit = "kJ/kmol") = -393520 "enthalpy of formation of CO2";
    parameter Real hCOf(unit = "kJ/kmol") = -110530 "enthalpy of formation of CO";
    parameter Real hO2f(unit = "kJ/kmol") = 0 "enthalpy of formation of O2";
    parameter Real sCO2(unit = "kJ/kmol.K") = 213.69 "absolute entropy of CO2";
    parameter Real sCO(unit = "kJ/kmol.K") = 197.54 "absolute entropy of CO";
    parameter Real sO2(unit = "kJ/kmol.K") = 205.03 "absolute entropy of O2";      
                                                                /*From Table T-25. 
                                                                Appendix Pg:A-46*/  
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real del_G(unit = "kJ/kmol") "change in Gibbs function";
    Real lnK(unit = "-") "equilibrium constant ln K";
    Real log10K(unit="-")"equilibrium constant log10 K";
    //===============================
    
    //equation selection
    equation
      del_G = hCO2f - hCOf - 1 / 2 * hO2f - T * (sCO2 - sCO - 1 / 2 * sO2); 
                                                              //From Eq.14.29b, Pg:563
      lnK = -del_G / (R * T);                                 //From Eq.14.31, Pg:563
      lnK=2.303*log10K;                                       //Natural logarithm and logarithm base 10 relation
  end Ex14_1_a;
  //===============================
  model Ex14_1_b
  //To find equilibrium constant at 298 K
    
    //parameter selection
    parameter Real T(unit = "K") = 2000 "reaction temperature";
    parameter Real hCO2f(unit = "kJ/kmol") = -393520 "enthalpy of formation of CO2";
    parameter Real hCOf(unit = "kJ/kmol") = -110530 "enthalpy of formation of CO";
    parameter Real hO2f(unit = "kJ/kmol") = 0 "enthalpy of formation of O2";     
                                                                /*From Table T-25. 
                                                                Appendix Pg:A-46*/  
    parameter Real hCO2_T1(unit="kJ/kmol")=9364"specific enthalpy of CO2 at T1";
    parameter Real hCO_T1(unit="kJ/kmol")=8669"specific enthalpy of CO at T1";
    parameter Real hO2_T1(unit="kJ/kmol")=8682"specific enthalpy of O2 at T1";
                                                                /*From Table A-23 at T=298 K. 
                                                                Appendix Pg:A-41*/
    parameter Real hCO2_T2(unit="kJ/kmol")=100804"specific enthalpy of CO2 at T2";
    parameter Real sCO2_T2(unit = "kJ/kmol.K") = 309.210 "absolute entropy of CO2 at T2";
    parameter Real hCO_T2(unit="kJ/kmol")=65408"specific enthalpy of CO at T2";
    parameter Real sCO_T2(unit = "kJ/kmol.K") = 258.600 "absolute entropy of CO at T2";
    parameter Real hO2_T2(unit="kJ/kmol")=67881"specific enthalpy of O2 at T2";
    parameter Real sO2_T2(unit = "kJ/kmol.K") = 268.655 "absolute entropy of O2 at T2";
                                                                /*From Table A-23 at T=2000 K. 
                                                                Appendix Pg:A-44*/
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real del_G(unit = "kJ/kmol") "change in Gibbs function";
    Real lnK(unit = "-") "equilibrium constant ln K";
    Real log10K(unit="-")"equilibrium constant log10 K";
    //===============================
    
    //equation selection
    equation
    del_G=(hCO2f-hCOf-1/2*hO2f)+((hCO2_T2-hCO2_T1)-(hCO_T2-hCO_T1)-1/2*(hO2_T2-hO2_T1))-T*(sCO2_T2-sCO_T2-1/2*sO2_T2);
                                                              //From Eq.14.29b, Pg:563
      lnK = -del_G / (R * T);                                 //From Eq.14.31, Pg:563
      lnK=2.303*log10K;                                       //Natural logarithm and logarithm base 10 relation

  end Ex14_1_b;
  //===============================
end Ex14_1;
