/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_10 Page:581
//Title:Modeling Equilibrium of Moist Air in Contact with Liquid Water
//===============================
package Ex14_10
  model Ex14_10_b
  
    //parameter selection
    parameter Real T(unit="F")=70"temperature";
    parameter Real p(unit="atm")=1"total pressure";
    parameter Real psat(unit="lbf/in2")=0.3632"saturation pressure";
    parameter Real vf(unit="ft3/lb")=0.01605"specific volume";
                                                  /*From Table A-2E for T=70 F. 
                                                  Appendix Pg:A-51*/
    final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 18.02 "molecular mass of water";
    //===============================
    
    //variable selection
    Real pv_psat(unit="-")"ratio of partial pressure to saturation pressure";
    //===============================
    
    //equation selection
    equation
      pv_psat=exp(vf*(p*14.696-psat)*144/(R/M*(T+459.67))); //From equation derived from part (a), Pg:581
                                                            //Multiplying by 14.696 to convert into lbf/in^2
                                                            //Multiplying by 144 to convert into in^2
                                                            //Adding 459.67 to convert into Rankine scale
  end Ex14_10_b;
  //===============================
end Ex14_10;
