/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_3 Page:566
//Title:Determining Equilibrium Temperature Given Pressure and Composition
//===============================
model Ex14_3
  
  //parameter selection
  parameter Real pref(unit = "atm") = 1 "reference pressure";
  parameter Real p(unit = "atm") = 1 "mixture pressure";
  parameter Real yCO(unit = "-")=0.298"mole fraction of CO";
  parameter Real yCO2(unit = "-")=0.553 "mole fraction of CO2";
  parameter Real yO2(unit = "-")=0.149 "mole fraction of O2";
  parameter Real T1(unit="K")=2800"temperature 1 for interpolation";
  parameter Real T2(unit="K")=2900"temperature 2 for interpolation";
  parameter Real log10K1(unit="-")=-0.825"log base10(K) 1 for interpolation";
  parameter Real log10K2(unit="-")=-0.649"log base10(K) 2 for interpolation";
                                                      /*From Table A-27 for interpolating 
                                                      log10(K)=-0.681916. Appendix Pg:A-48*/
  //===============================
  
  //variable selection
  Real z(unit = "-") "stoichiometric coefficient";
  Real K(unit="-")"equilibrium constant";
  Real log10K(unit="-")"log base 10 of equilibrium constant";
  Real T(unit="K")"temperature of the mixture";
  //===============================
  
  //equation selection
  equation
    K=z/(1-z)*(z/(2+z))^(1/2)*(p/pref)^(1/2);             //Equilibrium constant 
                                                          //From Eq.14.35, Pg:565
    yCO=2*z /(2+z);                                       //Mole fraction
    log10K=log10(K);
    (T-T1)/(T2-T1)=(log10K-log10K1)/(log10K2-log10K1);    //Interpolation
end Ex14_3;
//===============================




