/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_5 Page:568
//Title:Using Equilibrium Concepts with the Energy Balance
//===============================
model Ex14_5

    //parameter selection
    parameter Real K(unit="-")=0.647"equilibrium constant";
                                                /*From Table A-27 at T=3200 K 
                                                value of K for CO2 reaction. 
                                                Appendix Pg:A-48*/
    parameter Real hCO2f(unit="kJ/kmol")=-393520"enthalpy of foramtion of CO2";
    parameter Real hCOf(unit="kJ/kmol")=-110530"enthalpy of formation of CO";
                                                /*From Table A-25. 
                                                Appendix Pg:A-46*/
    parameter Real hCO2_T1(unit="kJ/kmol")=9364"specific enthalpy of CO2 at inlet";
    parameter Real hCO_T1(unit="kJ/kmol")=8669"specific enthalpy of CO at inlet";
    parameter Real hO2_T1(unit="kJ/kmol")=8682"specific enthalpy of O2 at inlet";
                                                /*From Table A-23 at T=298 K. 
                                                Appendix Pg:A-41*/
    parameter Real hCO2_T2(unit="kJ/kmol")=174695"specific enthalpy of CO2 at exit";
    parameter Real hCO_T2(unit="kJ/kmol")=109667"specific enthalpy of CO at exit";
    parameter Real hO2_T2(unit="kJ/kmol")=114809"specific enthalpy of O2 at exit";
                                                /*From Table A-23 at T=3200 K. 
                                                Appendix Pg:A-44*/
    //===============================
    
    //variable selection
    Real Qcv_n(unit="kJ/kmol(CO2)")"heat transfer per kmol of CO2";
    Real z(unit="kmol")"amount of CO2";
    //===============================
    
    //equation selection
    equation
      K=((1-z)/z)*((1-z)/(3-z))^0.5;                   //Equilibrium constant 
                                                       //From Eq.14.35, Pg:565
      Qcv_n=z*(hCO2f+hCO2_T2-hCO2_T1)+(1-z)*(hCOf+hCO_T2-hCO_T1)+(1-z)/2*(hO2_T2-hO2_T1)-hCO2f;      
                                                       //Reduced energy rate balance

end Ex14_5;
//===============================
